"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanContentPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../../utils");
var _column_chart = require("./column_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_row/boolean_content_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BooleanContentPreview = ({
  config
}) => {
  const chartData = (0, _react.useMemo)(() => {
    const results = (0, _utils.getTFPercentage)(config);
    if (results) {
      const data = [{
        key: 'true',
        key_as_string: 'true',
        doc_count: results.trueCount
      }, {
        key: 'false',
        key_as_string: 'false',
        doc_count: results.falseCount
      }];
      return {
        id: config.fieldName,
        cardinality: 2,
        data,
        type: 'boolean'
      };
    }
  }, [config]);
  if (!chartData || config.fieldName === undefined) return null;
  const columnType = {
    id: config.fieldName,
    schema: undefined
  };
  const dataTestSubj = `dataVisualizerDataGridChart-${config.fieldName}`;
  return /*#__PURE__*/_react.default.createElement(_column_chart.ColumnChart, {
    dataTestSubj: dataTestSubj,
    chartData: chartData,
    columnType: columnType,
    hideLabel: true,
    maxChartColumns: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.BooleanContentPreview = BooleanContentPreview;