"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditIndexPatternContainer = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _ = require(".");
var _breadcrumbs = require("../breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/edit_index_pattern_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditIndexPatternCont = ({
  ...props
}) => {
  const {
    dataViews,
    setBreadcrumbs,
    notifications,
    dataViewMgmtService
  } = (0, _public.useKibana)().services;
  const [error, setError] = (0, _react.useState)();
  const [indexPattern, setIndexPattern] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    dataViews.get(decodeURIComponent(props.match.params.id), undefined, true).then(ip => {
      dataViewMgmtService.setDataView(ip);
      setIndexPattern(ip);
      setBreadcrumbs((0, _breadcrumbs.getEditBreadcrumbs)(ip));
    }).catch(err => {
      setError(err);
    });
  }, [dataViews, props.match.params.id, setBreadcrumbs, setError, dataViewMgmtService]);
  if (error) {
    const [errorTitle, errorMessage] = [_i18n.i18n.translate('indexPatternManagement.editIndexPattern.couldNotLoadTitle', {
      defaultMessage: 'Unable to load data view'
    }), _i18n.i18n.translate('indexPatternManagement.editIndexPattern.couldNotLoadMessage', {
      defaultMessage: 'The data view with id:{objectId} could not be loaded. Try creating a new one.',
      values: {
        objectId: props.match.params.id
      }
    })];
    notifications.toasts.addError(error !== null && error !== void 0 ? error : new Error(errorTitle), {
      title: errorTitle,
      toastMessage: errorMessage
    });
    props.history.push('/');
  }
  return indexPattern != null ? /*#__PURE__*/_react.default.createElement(_.EditIndexPattern, {
    indexPattern: indexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 33
    }
  }) : null;
};
const EditIndexPatternContainer = exports.EditIndexPatternContainer = (0, _reactRouterDom.withRouter)(EditIndexPatternCont);