"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewFieldList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _field_editor_context = require("../../field_editor_context");
var _field_preview_context = require("../field_preview_context");
var _field_list_item = require("./field_list_item");
var _state_utils = require("../../../state_utils");
var _get_item_position = require("./get_item_position");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/field_list/field_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Escape regex special characters (e.g /, ^, $...) with a "\"
 * Copied from https://stackoverflow.com/a/9310752
 */
function escapeRegExp(text) {
  return text.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
function fuzzyMatch(searchValue, text) {
  const pattern = `.*${searchValue.split('').map(escapeRegExp).join('.*')}.*`;
  const regex = new RegExp(pattern, 'i');
  return regex.test(text);
}
const pinnedFieldsSelector = s => s.pinnedFields;
const currentDocumentSelector = s => s.documents[s.currentIdx];
const fieldMapSelector = s => s.fieldMap;
const Row = /*#__PURE__*/_react.default.memo(({
  data,
  index,
  style
}) => {
  // Data passed to List as "itemData" is available as props.data
  const {
    filteredFields,
    toggleIsPinned
  } = data;
  const field = filteredFields[index];
  return /*#__PURE__*/_react.default.createElement("div", {
    key: field.key,
    style: style,
    "data-test-subj": "indexPatternFieldList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_list_item.PreviewListItem, {
    key: field.key,
    field: field,
    toggleIsPinned: toggleIsPinned,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
}, _reactWindow.areEqual);
const PreviewFieldList = ({
  height,
  clearSearch,
  searchValue = ''
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    dataView
  } = (0, _field_editor_context.useFieldEditorContext)();
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const virtualListRef = (0, _react.useRef)(null);
  const pinnedFields = (0, _state_utils.useStateSelector)(controller.state$, pinnedFieldsSelector, _lodash.isEqual);
  const currentDocument = (0, _state_utils.useStateSelector)(controller.state$, currentDocumentSelector);
  const fieldMap = (0, _state_utils.useStateSelector)(controller.state$, fieldMapSelector);
  const [showAllFields, setShowAllFields] = (0, _react.useState)(false);
  const fieldList = (0, _react.useMemo)(() => Object.values(fieldMap).map(field => {
    const {
      name,
      displayName
    } = field;
    const formatter = dataView.getFormatterForField(field);
    const value = (0, _lodash.get)(currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument.fields, name);
    const formattedValue = formatter.convert(value, 'html');
    return {
      key: displayName,
      value,
      formattedValue,
      isPinned: false
    };
  }).filter(({
    value
  }) => value !== undefined), [dataView, fieldMap, currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument.fields]);
  const fieldListWithPinnedFields = (0, _react.useMemo)(() => {
    const pinned = [];
    const notPinned = [];
    fieldList.forEach(field => {
      if (pinnedFields[field.key]) {
        pinned.push({
          ...field,
          isPinned: true
        });
      } else {
        notPinned.push({
          ...field,
          isPinned: false
        });
      }
    });
    return [...pinned, ...notPinned];
  }, [fieldList, pinnedFields]);
  const {
    filteredFields,
    totalFields
  } = (0, _react.useMemo)(() => {
    const list = searchValue.trim() === '' ? fieldListWithPinnedFields : fieldListWithPinnedFields.filter(({
      key
    }) => fuzzyMatch(searchValue, key));
    const total = list.length;
    if (showAllFields) {
      return {
        filteredFields: list,
        totalFields: total
      };
    }
    return {
      filteredFields: list.filter((_, i) => i < _constants.INITIAL_MAX_NUMBER_OF_FIELDS),
      totalFields: total
    };
  }, [fieldListWithPinnedFields, showAllFields, searchValue]);
  const hasSearchValue = searchValue.trim() !== '';
  const isEmptySearchResultVisible = hasSearchValue && totalFields === 0;

  // "height" corresponds to the total height of the flex item that occupies the remaining
  // vertical space up to the bottom of the flyout panel. We don't want to give that height
  // to the virtual list because it would mean that the "Show more" button would be pinned to the
  // bottom of the panel all the time. Which is not what we want when we render initially a few
  // fields.
  const listHeight = Math.min(filteredFields.length * _constants.ITEM_HEIGHT, height - _constants.SHOW_MORE_HEIGHT);
  const toggleShowAllFields = (0, _react.useCallback)(() => {
    setShowAllFields(prev => !prev);
  }, []);
  const renderEmptyResult = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        css: styles.emptySearchResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.searchResult.emptyPromptTitle', {
        defaultMessage: 'No matching fields in this data view'
      }))),
      titleSize: "xs",
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: clearSearch,
        "data-test-subj": "clearSearchButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.searchResult.emptyPrompt.clearSearchButtonLabel', {
        defaultMessage: 'Clear search'
      })),
      "data-test-subj": "emptySearchResult",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }));
  };
  const renderToggleFieldsButton = () => totalFields <= _constants.INITIAL_MAX_NUMBER_OF_FIELDS ? null : /*#__PURE__*/_react.default.createElement("div", {
    css: styles.showMore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleShowAllFields,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, showAllFields ? _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.showLessFieldsButtonLabel', {
    defaultMessage: 'Show less'
  }) : _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.showMoreFieldsButtonLabel', {
    defaultMessage: 'Show more'
  })));
  const toggleIsPinnedItem = (0, _react.useCallback)((fieldName, keyboardEvent) => {
    controller.togglePinnedField(fieldName);
    if (!keyboardEvent.isKeyboardEvent) return;
    const newIndex = (0, _get_item_position.getPositionAfterToggling)(fieldName, pinnedFields, fieldList);
    // If the field is currently pinned and it goes over the limit of the fields to show we need to show all of them
    if (newIndex >= _constants.INITIAL_MAX_NUMBER_OF_FIELDS && !showAllFields) toggleShowAllFields();
    requestAnimationFrame(() => {
      var _virtualListRef$curre;
      (_virtualListRef$curre = virtualListRef.current) === null || _virtualListRef$curre === void 0 ? void 0 : _virtualListRef$curre.scrollToItem(newIndex, 'smart');
      // We need to wait for the scroll to finish so the element is in the DOM before focusing it
      requestAnimationFrame(() => {
        var _document$getElementB;
        (_document$getElementB = document.getElementById(keyboardEvent.buttonId)) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.focus();
      });
    });
  }, [controller, showAllFields, pinnedFields, fieldList, toggleShowAllFields]);
  const itemData = (0, _react.useMemo)(() => ({
    filteredFields,
    toggleIsPinned: toggleIsPinnedItem
  }), [filteredFields, toggleIsPinnedItem]);
  if (currentDocument === undefined || height === -1) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewFieldList",
    css: styles.previewFieldList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 5
    }
  }, isEmptySearchResultVisible ? renderEmptyResult() : /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList, {
    className: "eui-scrollBar",
    style: {
      overflowX: 'hidden'
    },
    width: "100%",
    ref: virtualListRef,
    height: listHeight,
    itemData: itemData,
    itemCount: filteredFields.length,
    itemSize: _constants.ITEM_HEIGHT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }, Row), renderToggleFieldsButton());
};
exports.PreviewFieldList = PreviewFieldList;
const componentStyles = {
  emptySearchResult: ({
    euiTheme
  }) => (0, _react2.css)({
    fontWeight: euiTheme.font.weight.medium
  }),
  previewFieldList: (0, _react2.css)({
    position: 'relative'
  }),
  showMore: (0, _react2.css)({
    position: 'absolute',
    width: '100%',
    height: _constants.SHOW_MORE_HEIGHT,
    bottom: -_constants.SHOW_MORE_HEIGHT,
    display: 'flex',
    alignItems: 'flex-end'
  })
};