"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = exports.DEFAULT_THEME_NAME_FEATURE_FLAG = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _views = require("./views");
var _bootstrap = require("./bootstrap");
var _render_utils = require("./render_utils");
var _filter_ui_plugins = require("./filter_ui_plugins");
var _get_apm_config = require("./get_apm_config");
var _theme = require("./theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/rendering/server-internal/src/rendering_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const themeVersion = 'v8';

// TODO: Remove the temporary feature flag and supporting code when Borealis is live in Serverless
// https://github.com/elastic/eui-private/issues/192
const DEFAULT_THEME_NAME_FEATURE_FLAG = exports.DEFAULT_THEME_NAME_FEATURE_FLAG = 'coreRendering.defaultThemeName';

/** @internal */
class RenderingService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "themeName$", new _rxjs.BehaviorSubject(_coreUiSettingsCommon.DEFAULT_THEME_NAME));
    this.coreContext = coreContext;
  }
  async preboot({
    http,
    uiPlugins,
    i18n
  }) {
    http.registerRoutes('', router => {
      (0, _bootstrap.registerBootstrapRoute)({
        router,
        renderer: (0, _bootstrap.bootstrapRendererFactory)({
          uiPlugins,
          baseHref: http.staticAssets.getHrefBase(),
          packageInfo: this.coreContext.env.packageInfo,
          auth: http.auth,
          themeName$: this.themeName$
        })
      });
    });
    return {
      render: this.render.bind(this, {
        http,
        uiPlugins,
        i18n
      })
    };
  }
  async setup({
    elasticsearch,
    featureFlags,
    http,
    status,
    uiPlugins,
    customBranding,
    userSettings,
    i18n
  }) {
    (0, _bootstrap.registerBootstrapRoute)({
      router: http.createRouter(''),
      renderer: (0, _bootstrap.bootstrapRendererFactory)({
        uiPlugins,
        baseHref: http.staticAssets.getHrefBase(),
        packageInfo: this.coreContext.env.packageInfo,
        auth: http.auth,
        themeName$: this.themeName$,
        userSettingsService: userSettings
      })
    });
    return {
      render: this.render.bind(this, {
        elasticsearch,
        featureFlags,
        http,
        uiPlugins,
        status,
        customBranding,
        userSettings,
        i18n
      })
    };
  }
  start({
    featureFlags
  }) {
    featureFlags.getStringValue$(DEFAULT_THEME_NAME_FEATURE_FLAG, _coreUiSettingsCommon.DEFAULT_THEME_NAME)
    // Parse the input feature flag value to ensure it's of type ThemeName
    // and that it's bundled with this build of Kibana
    .pipe((0, _rxjs.map)(themeName => {
      if ((0, _theme.isThemeBundled)(themeName)) {
        return (0, _coreUiSettingsCommon.parseThemeNameValue)(themeName);
      }
      return _coreUiSettingsCommon.DEFAULT_THEME_NAME;
    })).subscribe(this.themeName$);
  }
  async render(renderOptions, request, uiSettings, {
    isAnonymousPage = false,
    includeExposedConfigKeys
  } = {}) {
    var _uiSettings$client, _uiSettings$client2, _uiSettings$globalCli, _uiSettings$globalCli2, _uiSettings$globalCli3, _settings$user$theme, _settings$user$theme2, _branding, _branding2, _branding3, _branding4, _status$isStatusPageA, _branding5, _branding6, _branding7;
    const {
      elasticsearch,
      featureFlags,
      http,
      uiPlugins,
      status,
      customBranding,
      userSettings,
      i18n
    } = renderOptions;
    const env = {
      mode: this.coreContext.env.mode,
      packageInfo: this.coreContext.env.packageInfo
    };
    const staticAssetsHrefBase = http.staticAssets.getHrefBase();
    const usingCdn = http.staticAssets.isUsingCdn();
    const basePath = http.basePath.get(request);
    const {
      serverBasePath,
      publicBaseUrl
    } = http.basePath;

    // Grouping all async HTTP requests to run them concurrently for performance reasons.
    const [defaultSettings, settingsUserValues = {}, globalSettingsUserValues = {}, userSettingDarkMode] = await Promise.all([
    // All sites
    withAsyncDefaultValues(request, (_uiSettings$client = uiSettings.client) === null || _uiSettings$client === void 0 ? void 0 : _uiSettings$client.getRegistered()),
    // Only non-anonymous pages
    ...(!isAnonymousPage ? [(_uiSettings$client2 = uiSettings.client) === null || _uiSettings$client2 === void 0 ? void 0 : _uiSettings$client2.getUserProvided(), (_uiSettings$globalCli = uiSettings.globalClient) === null || _uiSettings$globalCli === void 0 ? void 0 : _uiSettings$globalCli.getUserProvided(), // dark mode
    userSettings === null || userSettings === void 0 ? void 0 : userSettings.getUserSettingDarkMode(request)] : [])]);
    const settings = {
      defaults: defaultSettings,
      user: settingsUserValues
    };
    const globalSettings = {
      defaults: (_uiSettings$globalCli2 = (_uiSettings$globalCli3 = uiSettings.globalClient) === null || _uiSettings$globalCli3 === void 0 ? void 0 : _uiSettings$globalCli3.getRegistered()) !== null && _uiSettings$globalCli2 !== void 0 ? _uiSettings$globalCli2 : {},
      user: globalSettingsUserValues
    };
    let clusterInfo = {};
    let branding = {};
    try {
      // Only provide the clusterInfo if the request is authenticated and the elasticsearch service is available.
      const authenticated = isAuthenticated(http.auth, request);
      if (authenticated && elasticsearch) {
        clusterInfo = await (0, _rxjs.firstValueFrom)(elasticsearch.clusterInfo$.pipe((0, _rxjs.timeout)(50),
        // If not available, just return undefined
        (0, _rxjs.catchError)(() => (0, _rxjs.of)({}))));
      }
      branding = await (customBranding === null || customBranding === void 0 ? void 0 : customBranding.getBrandingFor(request, {
        unauthenticated: !authenticated
      }));
    } catch (err) {
      // swallow error
    }

    // dark mode
    const isThemeOverridden = (_settings$user$theme = (_settings$user$theme2 = settings.user['theme:darkMode']) === null || _settings$user$theme2 === void 0 ? void 0 : _settings$user$theme2.isOverridden) !== null && _settings$user$theme !== void 0 ? _settings$user$theme : false;
    let darkMode;
    if (userSettingDarkMode !== undefined && !isThemeOverridden) {
      darkMode = userSettingDarkMode;
    } else {
      darkMode = (0, _render_utils.getSettingValue)('theme:darkMode', settings, _coreUiSettingsCommon.parseDarkModeValue);
    }
    const themeStylesheetPaths = mode => (0, _render_utils.getThemeStylesheetPaths)({
      darkMode: mode,
      baseHref: staticAssetsHrefBase
    });
    const commonStylesheetPaths = (0, _render_utils.getCommonStylesheetPaths)({
      baseHref: staticAssetsHrefBase
    });
    const themeName = this.themeName$.getValue();
    const scriptPaths = (0, _render_utils.getScriptPaths)({
      themeName,
      darkMode,
      baseHref: staticAssetsHrefBase
    });
    const loggingConfig = await (0, _render_utils.getBrowserLoggingConfig)(this.coreContext.configService);
    const locale = _i18n.i18n.getLocale();
    let translationsUrl;
    if (usingCdn) {
      translationsUrl = `${staticAssetsHrefBase}/translations/${locale}.json`;
    } else {
      const translationHash = i18n.getTranslationHash();
      translationsUrl = `${serverBasePath}/translations/${translationHash}/${locale}.json`;
    }
    const apmConfig = (0, _get_apm_config.getApmConfig)(request.url.pathname);
    const filteredPlugins = (0, _filter_ui_plugins.filterUiPlugins)({
      uiPlugins,
      isAnonymousPage
    });
    const bootstrapScript = isAnonymousPage ? 'bootstrap-anonymous.js' : 'bootstrap.js';
    const metadata = {
      strictCsp: http.csp.strict,
      hardenPrototypes: http.prototypeHardening,
      uiPublicUrl: `${staticAssetsHrefBase}/ui`,
      bootstrapScriptUrl: `${basePath}/${bootstrapScript}`,
      locale,
      themeVersion,
      darkMode,
      stylesheetPaths: commonStylesheetPaths,
      scriptPaths,
      customBranding: {
        faviconSVG: (_branding = branding) === null || _branding === void 0 ? void 0 : _branding.faviconSVG,
        faviconPNG: (_branding2 = branding) === null || _branding2 === void 0 ? void 0 : _branding2.faviconPNG,
        pageTitle: (_branding3 = branding) === null || _branding3 === void 0 ? void 0 : _branding3.pageTitle,
        logo: (_branding4 = branding) === null || _branding4 === void 0 ? void 0 : _branding4.logo
      },
      injectedMetadata: {
        version: env.packageInfo.version,
        buildNumber: env.packageInfo.buildNum,
        branch: env.packageInfo.branch,
        basePath,
        serverBasePath,
        publicBaseUrl,
        assetsHrefBase: staticAssetsHrefBase,
        logging: loggingConfig,
        env,
        featureFlags: {
          overrides: (featureFlags === null || featureFlags === void 0 ? void 0 : featureFlags.getOverrides()) || {},
          initialFeatureFlags: (await (featureFlags === null || featureFlags === void 0 ? void 0 : featureFlags.getInitialFeatureFlags())) || {}
        },
        clusterInfo,
        apmConfig,
        anonymousStatusPage: (_status$isStatusPageA = status === null || status === void 0 ? void 0 : status.isStatusPageAnonymous()) !== null && _status$isStatusPageA !== void 0 ? _status$isStatusPageA : false,
        i18n: {
          translationsUrl
        },
        theme: {
          darkMode,
          name: themeName,
          version: themeVersion,
          stylesheetPaths: {
            default: themeStylesheetPaths(false),
            dark: themeStylesheetPaths(true)
          }
        },
        customBranding: {
          logo: (_branding5 = branding) === null || _branding5 === void 0 ? void 0 : _branding5.logo,
          customizedLogo: (_branding6 = branding) === null || _branding6 === void 0 ? void 0 : _branding6.customizedLogo,
          pageTitle: (_branding7 = branding) === null || _branding7 === void 0 ? void 0 : _branding7.pageTitle
        },
        csp: {
          warnLegacyBrowsers: http.csp.warnLegacyBrowsers
        },
        externalUrl: http.externalUrl,
        uiPlugins: await Promise.all(filteredPlugins.map(async ([id, plugin]) => {
          const {
            browserConfig,
            exposedConfigKeys
          } = await getUiConfig(uiPlugins, id);
          return {
            id,
            plugin,
            config: browserConfig,
            ...(includeExposedConfigKeys && {
              exposedConfigKeys
            })
          };
        })),
        legacyMetadata: {
          uiSettings: settings,
          globalUiSettings: globalSettings
        }
      }
    };
    return `<!DOCTYPE html>${(0, _server.renderToStaticMarkup)(/*#__PURE__*/_react.default.createElement(_views.Template, {
      metadata: metadata,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 51
      }
    }))}`;
  }
  async stop() {}
}
exports.RenderingService = RenderingService;
const getUiConfig = async (uiPlugins, pluginId) => {
  var _await$browserConfig$;
  const browserConfig = uiPlugins.browserConfigs.get(pluginId);
  return (_await$browserConfig$ = await (browserConfig === null || browserConfig === void 0 ? void 0 : browserConfig.pipe((0, _rxjs.take)(1)).toPromise())) !== null && _await$browserConfig$ !== void 0 ? _await$browserConfig$ : {
    browserConfig: {},
    exposedConfigKeys: {}
  };
};
const isAuthenticated = (auth, request) => {
  const {
    status: authStatus
  } = auth.get(request);
  // status is 'unknown' when auth is disabled. we just need to not be `unauthenticated` here.
  return authStatus !== 'unauthenticated';
};

/**
 * Load async values from the definitions that have a `getValue()` function
 *
 * @param defaultSettings The default settings to add async values to
 * @param request The current KibanaRequest
 * @returns The default settings with values updated with async values
 */
const withAsyncDefaultValues = async (request, defaultSettings = {}) => {
  const updatedSettings = {
    ...defaultSettings
  };
  await Promise.all(Object.entries(defaultSettings).filter(([_, definition]) => typeof definition.getValue === 'function').map(([key, definition]) => {
    return definition.getValue({
      request
    }).then(value => {
      updatedSettings[key] = {
        ...definition,
        value
      };
    });
  }));
  return updatedSettings;
};