"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsTypeValidator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _semver = _interopRequireDefault(require("semver"));
var _schema = require("./schema");
var _model_version = require("../model_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper class that takes a {@link SavedObjectsValidationMap} and runs validations for a
 * given type based on the provided Kibana version.
 *
 * @internal
 */
class SavedObjectsTypeValidator {
  constructor({
    logger,
    type,
    validationMap,
    defaultVersion
  }) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "defaultVersion", void 0);
    (0, _defineProperty2.default)(this, "validationMap", void 0);
    (0, _defineProperty2.default)(this, "orderedVersions", void 0);
    this.log = logger;
    this.type = type;
    this.defaultVersion = defaultVersion;
    this.validationMap = typeof validationMap === 'function' ? validationMap() : validationMap;
    this.orderedVersions = Object.keys(this.validationMap).sort(_semver.default.compare);
  }
  validate(document) {
    var _document$typeMigrati, _document$migrationVe;
    let usedVersion;
    const docVersion = (_document$typeMigrati = document.typeMigrationVersion) !== null && _document$typeMigrati !== void 0 ? _document$typeMigrati : (_document$migrationVe = document.migrationVersion) === null || _document$migrationVe === void 0 ? void 0 : _document$migrationVe[document.type];
    if (docVersion) {
      usedVersion = (0, _model_version.isVirtualModelVersion)(docVersion) ? docVersion : this.defaultVersion;
    } else {
      usedVersion = this.defaultVersion;
    }
    const schemaVersion = previousVersionWithSchema(this.orderedVersions, usedVersion);
    let validationRule;
    if (schemaVersion && this.validationMap[schemaVersion]) {
      validationRule = this.validationMap[schemaVersion];
    }
    try {
      const validationSchema = (0, _schema.createSavedObjectSanitizedDocSchema)(validationRule);
      validationSchema.validate(document);
    } catch (e) {
      this.log.warn(`Error validating object of type [${this.type}] against version [${usedVersion}]`);
      throw e;
    }
  }
}
exports.SavedObjectsTypeValidator = SavedObjectsTypeValidator;
const previousVersionWithSchema = (orderedVersions, targetVersion) => {
  for (let i = orderedVersions.length - 1; i >= 0; i--) {
    const currentVersion = orderedVersions[i];
    if (_semver.default.lte(currentVersion, targetVersion)) {
      return currentVersion;
    }
  }
  return undefined;
};