"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachIndexBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _attach_index_logic = require("./attach_index_logic");
var _api = require("../../../common/types/api");
var _fetch_available_indices_api_logic = require("../../api/index/fetch_available_indices_api_logic");
var _format_api_name = require("../../utils/format_api_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/attach_index_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CREATE_NEW_INDEX_GROUP_LABEL = _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.optionsGroup.createNewIndex', {
  defaultMessage: 'Create new index'
});
const SELECT_EXISTING_INDEX_GROUP_LABEL = _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.optionsGroup.selectExistingIndex', {
  defaultMessage: 'Select existing index'
});
const AttachIndexBox = ({
  connector
}) => {
  var _data$indexNames$filt, _data$indexNames$some, _data$indexNames$some2, _attachApiError$body, _createApiError$body;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    indexName
  } = (0, _reactRouterDom.useParams)();
  const {
    createIndex,
    attachIndex,
    setConnector,
    checkIndexExists
  } = (0, _kea.useActions)((0, _attach_index_logic.AttachIndexLogic)({
    http
  }));
  const {
    isLoading: isSaveLoading,
    isExistLoading,
    indexExists,
    createApiError,
    attachApiError
  } = (0, _kea.useValues)((0, _attach_index_logic.AttachIndexLogic)({
    http
  }));
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_available_indices_api_logic.FetchAvailableIndicesAPILogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(_fetch_available_indices_api_logic.FetchAvailableIndicesAPILogic);
  const isLoading = [_api.Status.IDLE, _api.Status.LOADING].includes(status);

  // Helper function to remove the managed connector index prefix from the index name
  const removePrefixConnectorIndex = connectorIndexName => {
    if (!connector.is_native) {
      return connectorIndexName;
    }
    if (connectorIndexName.startsWith(_searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX)) {
      return connectorIndexName.substring(_searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX.length);
    }
    return connectorIndexName;
  };

  // Helper function to add the managed connector index prefix to the index name
  const prefixConnectorIndex = connectorIndexName => {
    if (!connector.is_native) {
      return connectorIndexName;
    }
    if (connectorIndexName.startsWith(_searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX)) {
      return connectorIndexName;
    }
    return `${_searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX}${connectorIndexName}`;
  };
  const [query, setQuery] = (0, _react.useState)();
  const sanitizedNameWithoutPrefix = (0, _format_api_name.formatApiName)(connector.name);
  const [sanitizedName, setSanitizedName] = (0, _react.useState)(prefixConnectorIndex(sanitizedNameWithoutPrefix));
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)(
  // For managed connectors, the index name should be displayed without prefix
  // As `content-` is fixed UI element
  connector.index_name ? {
    label: removePrefixConnectorIndex(connector.index_name)
  } : undefined);
  const onSave = () => {
    if (!selectedIndex) return;
    // Always attach and/or create prefixed index for managed connectors
    const prefixedIndex = prefixConnectorIndex(selectedIndex.label);
    if (selectedIndex.shouldCreate) {
      createIndex({
        indexName: prefixedIndex,
        language: null,
        http
      });
    } else if (connector.index_name !== prefixedIndex) {
      attachIndex({
        connectorId: connector.id,
        indexName: prefixedIndex,
        http
      });
    }
  };

  // For managed connectors ensure that only prefixed indices are displayed in the dropdown
  // This takes care of the initial component state where all indices could be displayed briefly
  const options = isLoading ? [] : (_data$indexNames$filt = data === null || data === void 0 ? void 0 : data.indexNames.filter(name => !connector.is_native || name.startsWith(_searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX)).map(name => ({
    label: name,
    value: removePrefixConnectorIndex(name)
  }))) !== null && _data$indexNames$filt !== void 0 ? _data$indexNames$filt : [];
  const hasMatchingOptions = (_data$indexNames$some = data === null || data === void 0 ? void 0 : data.indexNames.some(name => {
    var _query$searchValue;
    return name.toLocaleLowerCase().includes(prefixConnectorIndex((query === null || query === void 0 ? void 0 : (_query$searchValue = query.searchValue) === null || _query$searchValue === void 0 ? void 0 : _query$searchValue.toLocaleLowerCase()) || ''));
  })) !== null && _data$indexNames$some !== void 0 ? _data$indexNames$some : false;
  const isFullMatch = (_data$indexNames$some2 = data === null || data === void 0 ? void 0 : data.indexNames.some(name => {
    var _query$searchValue2;
    return name.toLocaleLowerCase() === prefixConnectorIndex((query === null || query === void 0 ? void 0 : (_query$searchValue2 = query.searchValue) === null || _query$searchValue2 === void 0 ? void 0 : _query$searchValue2.toLocaleLowerCase()) || '');
  })) !== null && _data$indexNames$some2 !== void 0 ? _data$indexNames$some2 : false;
  const shouldPrependUserInputAsOption = !!query && !!query.searchValue && query.searchValue !== _searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX && hasMatchingOptions && !isFullMatch;
  const groupedOptions = shouldPrependUserInputAsOption ? [{
    label: CREATE_NEW_INDEX_GROUP_LABEL,
    options: [{
      label: prefixConnectorIndex(query.searchValue),
      value: query.searchValue
    }]
  }, {
    label: SELECT_EXISTING_INDEX_GROUP_LABEL,
    options
  }] : [{
    label: SELECT_EXISTING_INDEX_GROUP_LABEL,
    options
  }];
  (0, _react.useEffect)(() => {
    setConnector(connector);
    makeRequest({});
    if (!connector.index_name && connector.name && sanitizedName) {
      checkIndexExists({
        indexName: sanitizedName
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connector.id]);
  (0, _react.useEffect)(() => {
    makeRequest({
      searchQuery: (query === null || query === void 0 ? void 0 : query.searchValue) || undefined
    });
    if (query !== null && query !== void 0 && query.searchValue) {
      checkIndexExists({
        indexName: query.searchValue
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [query]);
  (0, _react.useEffect)(() => {
    // Suggested name for managed connector should include the content- prefix
    setSanitizedName(prefixConnectorIndex(sanitizedNameWithoutPrefix));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connector.name]);
  const {
    hash
  } = (0, _reactRouterDom.useLocation)();
  (0, _react.useEffect)(() => {
    if (hash) {
      const id = hash.replace('#', '');
      if (id === 'attachIndexBox') {
        const element = document.getElementById(id);
        if (element) {
          element.scrollIntoView({
            behavior: 'smooth'
          });
        }
      }
    }
  }, [hash]);
  const error = !!query && indexExists[query.searchValue] ? _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.associatedIndexErrorTextLabel', {
    defaultMessage: "You can't create a new index using an existing index name. Choose an existing index or create a new index with a new name."
  }) : (attachApiError === null || attachApiError === void 0 ? void 0 : (_attachApiError$body = attachApiError.body) === null || _attachApiError$body === void 0 ? void 0 : _attachApiError$body.message) || (createApiError === null || createApiError === void 0 ? void 0 : (_createApiError$body = createApiError.body) === null || _createApiError$body === void 0 ? void 0 : _createApiError$body.message) || undefined;
  if (indexName) {
    // Do not render when on the index route
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    id: "attachIndexBox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.h4.attachAnIndexLabel', {
    defaultMessage: 'Attach an index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchConnectors.attachIndexBox.thisIndexWillHoldTextLabel",
    defaultMessage: "This index will hold your data source content, and is optimized with default field mappings for relevant search experiences. Give your index a unique name and optionally set a default language analyzer for the index.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.associatedIndexLabel', {
      defaultMessage: 'Associated index'
    }),
    helpText: connector.is_native ? _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.associatedManagedConnectorIndexHelpTextLabel', {
      defaultMessage: 'Managed connector indices must be prefixed. Use an existing index or create a new one.'
    }) : _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.associatedIndexHelpTextLabel', {
      defaultMessage: 'You can use an existing index or create a new one.'
    }),
    error: error,
    isInvalid: !!error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!error,
    placeholder: _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.indexSelector.placeholder', {
      defaultMessage: 'Select or create an index'
    }),
    customOptionText: _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.euiFormRow.indexSelector.customOption', {
      defaultMessage: 'Create index {searchValue}',
      values: {
        searchValue: prefixConnectorIndex('{searchValue}')
      }
    }),
    isLoading: isLoading,
    options: groupedOptions,
    singleSelection: {
      asPlainText: connector.is_native
    },
    prepend: connector.is_native ? _searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX : undefined,
    onKeyDown: event => {
      // Index name should not contain spaces
      if (event.key === ' ') {
        event.preventDefault();
      }
    },
    onSearchChange: searchValue => {
      // Match by option value to ensure accurate comparison with non-prefixed
      // user input for managed connectors
      setQuery({
        isFullMatch: options.some(option => option.value === prefixConnectorIndex(searchValue)),
        searchValue: prefixConnectorIndex(searchValue)
      });
    },
    onChange: selection => {
      const currentSelection = selection[0];
      const selectedIndexOption = currentSelection ? {
        label: removePrefixConnectorIndex(currentSelection.label),
        shouldCreate: shouldPrependUserInputAsOption && currentSelection.value === (query === null || query === void 0 ? void 0 : query.searchValue)
      } : undefined;
      setSelectedIndex(selectedIndexOption);
    },
    selectedOptions: selectedIndex ? [selectedIndex] : undefined,
    onCreateOption: value => {
      setSelectedIndex({
        label: removePrefixConnectorIndex(value.trim()),
        shouldCreate: true
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-connectorDetail-saveConfigurationButton",
    "data-telemetry-id": "entSearchContent-connector-connectorDetail-saveConfigurationButton",
    onClick: onSave,
    disabled: !selectedIndex || prefixConnectorIndex(selectedIndex.label) === connector.index_name || !!error,
    isLoading: isSaveLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.saveConfigurationButtonLabel', {
    defaultMessage: 'Save configuration'
  })))), !connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.orPanelLabel', {
    defaultMessage: 'OR'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-connectorDetail-createAttachIndexButton",
    "data-test-subj": "entSearchContent-connector-connectorDetail-createAttachIndexButton",
    iconType: "sparkles",
    color: "primary",
    fill: true,
    onClick: () => {
      createIndex({
        indexName: sanitizedName,
        language: null
      });
      setSelectedIndex({
        label: sanitizedNameWithoutPrefix
      });
    },
    isLoading: isSaveLoading || isExistLoading,
    disabled: indexExists[sanitizedName],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.createSameIndexButtonLabel', {
    defaultMessage: 'Create and attach an index named {indexName}',
    values: {
      indexName: sanitizedName
    }
  })), indexExists[sanitizedName] && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchConnectorsattachIndexBox.indexNameExistsError', {
    defaultMessage: 'Index with name {indexName} already exists',
    values: {
      indexName: sanitizedName
    }
  }))))));
};
exports.AttachIndexBox = AttachIndexBox;