"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearanceSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _appearance_modal = require("./appearance_modal");
var _use_appearance_hook = require("./use_appearance_hook");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cloud_integrations/cloud_links/public/maybe_add_cloud_links/appearance_selector/appearance_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AppearanceSelector = ({
  security,
  core,
  closePopover,
  isServerless
}) => {
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
    core: core,
    security: security,
    toMountPoint: _reactKibanaMount.toMountPoint,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AppearanceSelectorUI, {
    core: core,
    security: security,
    closePopover: closePopover,
    isServerless: isServerless,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }));
};
exports.AppearanceSelector = AppearanceSelector;
function AppearanceSelectorUI({
  security,
  core,
  closePopover,
  isServerless
}) {
  const {
    isVisible
  } = (0, _use_appearance_hook.useAppearance)({
    uiSettingsClient: core.uiSettings,
    defaultColorMode: 'space_default',
    defaultContrastMode: 'standard'
  });
  const modalRef = (0, _react.useRef)(null);
  const closeModal = () => {
    var _modalRef$current;
    (_modalRef$current = modalRef.current) === null || _modalRef$current === void 0 ? void 0 : _modalRef$current.close();
    modalRef.current = null;
  };
  const openModal = () => {
    modalRef.current = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
      core: core,
      security: security,
      toMountPoint: _reactKibanaMount.toMountPoint,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_appearance_modal.AppearanceModal, {
      closeModal: closeModal,
      uiSettingsClient: core.uiSettings,
      isServerless: isServerless,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    })), core), {
      'data-test-subj': 'appearanceModal',
      maxWidth: 600
    });
  };
  if (!isVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "brush",
    size: "s",
    onClick: () => {
      openModal();
      closePopover();
    },
    "data-test-subj": "appearanceSelector",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceLinkText', {
    defaultMessage: 'Appearance'
  }));
}