"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_plugins = require("./use_plugins");
var _use_lens_button_toggle = require("./plugins/lens/use_lens_button_toggle");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MarkdownEditorComponent = /*#__PURE__*/(0, _react.forwardRef)(({
  ariaLabel,
  'data-test-subj': dataTestSubj,
  editorId,
  height,
  onChange,
  value,
  disabledUiPlugins,
  errors,
  ...props
}, ref) => {
  const astRef = (0, _react.useRef)(undefined);
  const [markdownErrorMessages, setMarkdownErrorMessages] = (0, _react.useState)([]);
  const onParse = (0, _react.useCallback)((err, {
    messages,
    ast
  }) => {
    setMarkdownErrorMessages(err ? [err] : messages);
    astRef.current = ast;
  }, []);
  const {
    parsingPlugins,
    processingPlugins,
    uiPlugins
  } = (0, _use_plugins.usePlugins)(disabledUiPlugins);
  const editorRef = (0, _react.useRef)(null);
  (0, _use_lens_button_toggle.useLensButtonToggle)({
    astRef,
    uiPlugins,
    editorRef: ref,
    value
  });

  // @ts-expect-error
  (0, _react.useImperativeHandle)(ref, () => {
    var _editorRef$current, _editorRef$current$te;
    if (!editorRef.current) {
      return null;
    }
    const editorNode = (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : (_editorRef$current$te = _editorRef$current.textarea) === null || _editorRef$current$te === void 0 ? void 0 : _editorRef$current$te.closest('.euiMarkdownEditor');
    return {
      ...editorRef.current,
      toolbar: editorNode === null || editorNode === void 0 ? void 0 : editorNode.querySelector('.euiMarkdownEditorToolbar')
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor
  // prevent images from displaying at full scale
  , (0, _extends2.default)({
    css: _utils.scaledMarkdownImages,
    ref: editorRef,
    "aria-label": ariaLabel,
    editorId: editorId,
    onChange: onChange,
    value: value,
    uiPlugins: uiPlugins,
    parsingPluginList: parsingPlugins,
    processingPluginList: processingPlugins,
    onParse: onParse,
    errors: [...markdownErrorMessages, ...(errors !== null && errors !== void 0 ? errors : [])],
    "data-test-subj": dataTestSubj,
    height: height
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
});
MarkdownEditorComponent.displayName = 'MarkdownEditor';
const MarkdownEditor = exports.MarkdownEditor = /*#__PURE__*/(0, _react.memo)(MarkdownEditorComponent);