"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _time_duration = require("../../../lib/time_duration");
var _i18n2 = require("../../../../i18n");
var _custom_interval = require("./custom_interval");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/view_menu/auto_refresh_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  time: timeStrings
} = _i18n2.UnitStrings;
const {
  getSecondsText,
  getMinutesText,
  getHoursText
} = timeStrings;
const strings = {
  getDisableTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.disableTooltip', {
    defaultMessage: 'Disable auto-refresh'
  }),
  getIntervalFormLabelText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.intervalFormLabel', {
    defaultMessage: 'Change auto-refresh interval'
  }),
  getRefreshListDurationManualText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.refreshListDurationManualText', {
    defaultMessage: 'Manually'
  }),
  getRefreshListTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.refreshListTitle', {
    defaultMessage: 'Refresh elements'
  })
};
const ListGroup = ({
  children,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
  style: {
    listStyle: 'none',
    margin: 0
  }
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 3
  }
}), [children]);
const generateId = (0, _eui.htmlIdGenerator)();
const AutoRefreshControls = ({
  refreshInterval,
  setRefresh,
  disableInterval
}) => {
  const RefreshItem = ({
    duration,
    label,
    descriptionId
  }) => /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setRefresh(duration),
    "aria-describedby": descriptionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, label));
  const interval = (0, _time_duration.timeDuration)(refreshInterval);
  const intervalTitleId = generateId();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    className: "canvasViewMenu__kioskSettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, strings.getRefreshListTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, refreshInterval > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeStrings.getCycleTimeText(interval.length, interval.format)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, strings.getRefreshListDurationManualText())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, refreshInterval > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: strings.getDisableTooltip(),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: disableInterval,
    "aria-label": strings.getDisableTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 21
    }
  }))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    id: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, strings.getIntervalFormLabelText())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ListGroup, {
    "aria-labelledby": intervalTitleId,
    className: "canvasControlSettings__list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 30000,
    label: getSecondsText(30),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 60000,
    label: getMinutesText(1),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 300000,
    label: getMinutesText(5),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 1800000,
    label: getMinutesText(30),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 3600000,
    label: getHoursText(1),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 43200000,
    label: getHoursText(12),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 86400000,
    label: getHoursText(24),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_interval.CustomInterval, {
    onSubmit: value => setRefresh(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  })));
};
exports.AutoRefreshControls = AutoRefreshControls;
AutoRefreshControls.propTypes = {
  refreshInterval: _propTypes.default.number,
  setRefresh: _propTypes.default.func.isRequired,
  disableInterval: _propTypes.default.func.isRequired
};