"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/saved_elements_modal/element_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getDeleteAriaLabel: () => _i18n.i18n.translate('xpack.canvas.elementControls.deleteAriaLabel', {
    defaultMessage: 'Delete element'
  }),
  getDeleteTooltip: () => _i18n.i18n.translate('xpack.canvas.elementControls.deleteToolTip', {
    defaultMessage: 'Delete'
  }),
  getEditAriaLabel: () => _i18n.i18n.translate('xpack.canvas.elementControls.editAriaLabel', {
    defaultMessage: 'Edit element'
  }),
  getEditTooltip: () => _i18n.i18n.translate('xpack.canvas.elementControls.editToolTip', {
    defaultMessage: 'Edit'
  })
};
const ElementControls = ({
  onDelete,
  onEdit
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "canvasElementCard__controls",
  gutterSize: "xs",
  justifyContent: "spaceBetween",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: strings.getEditTooltip(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  iconType: "pencil",
  "aria-label": strings.getEditAriaLabel(),
  onClick: onEdit,
  "data-test-subj": "canvasElementCard__editButton",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: strings.getDeleteTooltip(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "danger",
  iconType: "trash",
  "aria-label": strings.getDeleteAriaLabel(),
  onClick: onDelete,
  "data-test-subj": "canvasElementCard__deleteButton",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 9
  }
}))));
exports.ElementControls = ElementControls;
ElementControls.propTypes = {
  onDelete: _propTypes.default.func.isRequired,
  onEdit: _propTypes.default.func.isRequired
};