"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Paginate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _paginate = require("./paginate");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/paginate/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Paginate = ({
  perPage = 10,
  startPage = 0,
  rows,
  children
}) => {
  const totalPages = Math.ceil(rows.length / perPage);
  const initialCurrentPage = totalPages > 0 ? Math.min(startPage, totalPages - 1) : 0;
  const [currentPage, setPage] = (0, _react.useState)(initialCurrentPage);
  const hasRenderedRef = (0, _react.useRef)(false);
  const maxPage = Math.max(totalPages - 1, 0);
  const start = currentPage * perPage;
  const end = currentPage === 0 ? perPage : perPage * (currentPage + 1);
  const nextPageEnabled = currentPage < maxPage;
  const prevPageEnabled = currentPage > 0;
  const partialRows = rows.slice(start, end);
  const nextPage = () => {
    if (nextPageEnabled) {
      setPage(currentPage + 1);
    }
  };
  const prevPage = () => {
    if (prevPageEnabled) {
      setPage(currentPage - 1);
    }
  };
  (0, _react.useEffect)(() => {
    if (!hasRenderedRef.current) {
      hasRenderedRef.current = true;
    } else {
      setPage(0);
    }
  }, [perPage, hasRenderedRef]);
  (0, _react.useEffect)(() => {
    if (currentPage > maxPage) {
      setPage(maxPage);
    }
  }, [currentPage, maxPage]);
  return /*#__PURE__*/_react.default.createElement(_paginate.Paginate, {
    rows: partialRows,
    perPage: perPage,
    pageNumber: currentPage,
    totalPages: totalPages,
    setPage: setPage,
    nextPage: nextPage,
    prevPage: prevPage,
    nextPageEnabled: nextPageEnabled,
    prevPageEnabled: prevPageEnabled,
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.Paginate = Paginate;
Paginate.propTypes = {
  rows: _propTypes.default.array.isRequired,
  perPage: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  startPage: _propTypes.default.number
};