"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _routing = require("../../routing");
var _workpad_table_tools = require("./workpad_table_tools");
var _workpad_import = require("./workpad_import");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/my_workpads/workpad_table.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDisplayName = (name, workpadId, loadedWorkpadId) => {
  const workpadName = name.length ? /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 37
    }
  }, name) : /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 59
    }
  }, workpadId);
  return workpadId === loadedWorkpadId ? /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 42
    }
  }, workpadName) : workpadName;
};
const WorkpadTable = ({
  workpads,
  canUserWrite,
  dateFormat,
  onExportWorkpad: onExport,
  onCloneWorkpad
}) => {
  const [selectedIds, setSelectedIds] = (0, _react.useState)([]);
  const formatDate = date => date && (0, _moment.default)(date).format(dateFormat);
  const selection = {
    onSelectionChange: selectedWorkpads => {
      setSelectedIds(selectedWorkpads.map(workpad => workpad.id).filter(id => !!id));
    }
  };
  const actions = [{
    render: workpad => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: strings.getExportToolTip(),
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "exportAction",
      onClick: () => onExport(workpad.id),
      "aria-label": strings.getExportToolTip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: canUserWrite ? strings.getCloneToolTip() : strings.getNoPermissionToCloneToolTip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "copy",
      onClick: () => onCloneWorkpad(workpad.id),
      "aria-label": strings.getCloneToolTip(),
      disabled: !canUserWrite,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }))))
  }];
  const search = {
    toolsLeft: selectedIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_workpad_table_tools.WorkpadTableTools, {
      selectedWorkpadIds: selectedIds,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 32
      }
    }) : undefined,
    toolsRight: /*#__PURE__*/_react.default.createElement(_workpad_import.WorkpadImport, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }),
    box: {
      schema: true,
      incremental: true,
      placeholder: strings.getWorkpadSearchPlaceholder(),
      'data-test-subj': 'tableListSearchBox'
    }
  };
  const columns = [{
    field: 'name',
    name: strings.getTableNameColumnTitle(),
    sortable: true,
    dataType: 'string',
    render: (name, workpad) => /*#__PURE__*/_react.default.createElement(_routing.RoutingLink, {
      "data-test-subj": "canvasWorkpadTableWorkpad",
      to: `/workpad/${workpad.id}`,
      "aria-label": strings.getLoadWorkpadArialLabel(name.length ? name : workpad.id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }, getDisplayName(name, workpad.id))
  }, {
    field: '@created',
    name: strings.getTableCreatedColumnTitle(),
    sortable: true,
    dataType: 'date',
    width: '20%',
    render: date => formatDate(date)
  }, {
    field: '@timestamp',
    name: strings.getTableUpdatedColumnTitle(),
    sortable: true,
    dataType: 'date',
    width: '20%',
    render: date => formatDate(date)
  }, {
    name: strings.getTableActionsColumnTitle(),
    actions,
    width: '100px'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    items: workpads,
    columns: columns,
    message: strings.getNoWorkpadsFoundMessage(),
    search: search,
    sorting: {
      sort: {
        field: '@timestamp',
        direction: 'desc'
      }
    },
    pagination: true,
    selection: selection,
    "data-test-subj": "canvasWorkpadTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  });
};
exports.WorkpadTable = WorkpadTable;
const strings = {
  getCloneToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTable.cloneTooltip', {
    defaultMessage: 'Clone workpad'
  }),
  getExportToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTable.exportTooltip', {
    defaultMessage: 'Export workpad'
  }),
  getLoadWorkpadArialLabel: workpadName => _i18n.i18n.translate('xpack.canvas.workpadTable.loadWorkpadArialLabel', {
    defaultMessage: `Load workpad ''{workpadName}''`,
    values: {
      workpadName
    }
  }),
  getNoPermissionToCloneToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTable.noPermissionToCloneToolTip', {
    defaultMessage: `You don't have permission to clone workpads`
  }),
  getNoWorkpadsFoundMessage: () => _i18n.i18n.translate('xpack.canvas.workpadTable.noWorkpadsFoundMessage', {
    defaultMessage: 'No workpads matched your search.'
  }),
  getWorkpadSearchPlaceholder: () => _i18n.i18n.translate('xpack.canvas.workpadTable.searchPlaceholder', {
    defaultMessage: 'Find workpad'
  }),
  getTableCreatedColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTable.table.createdColumnTitle', {
    defaultMessage: 'Created',
    description: 'This column in the table contains the date/time the workpad was created.'
  }),
  getTableNameColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTable.table.nameColumnTitle', {
    defaultMessage: 'Workpad name'
  }),
  getTableUpdatedColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTable.table.updatedColumnTitle', {
    defaultMessage: 'Updated',
    description: 'This column in the table contains the date/time the workpad was last updated.'
  }),
  getTableActionsColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTable.table.actionsColumnTitle', {
    defaultMessage: 'Actions',
    description: 'This column in the table contains the actions that can be taken on a workpad.'
  })
};