"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TutorialFleetInstructions = TutorialFleetInstructions;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/tutorial_fleet_instructions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CentralizedContainer = _styled.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
`;
function TutorialFleetInstructions({
  http,
  basePath,
  isDarkTheme
}) {
  const [data, setData] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function fetchData() {
      setIsLoading(true);
      try {
        const response = await http.get('/internal/apm/fleet/migration_check');
        setData(response);
      } catch (e) {
        setIsLoading(false);
        console.error('Error while fetching fleet details.', e);
      }
      setIsLoading(false);
    }
    fetchData();
  }, [http]);
  const hasApmIntegrations = !!(data !== null && data !== void 0 && data.has_apm_integrations);
  const cloudApmMigrationEnabled = !!(data !== null && data !== void 0 && data.cloud_apm_migration_enabled);
  const hasCloudAgentPolicy = !!(data !== null && data !== void 0 && data.has_cloud_agent_policy);
  const cloudApmPackagePolicy = data === null || data === void 0 ? void 0 : data.cloud_apm_package_policy;
  const hasCloudApmPackagePolicy = !!cloudApmPackagePolicy;
  const hasRequiredRole = !!(data !== null && data !== void 0 && data.has_required_role);
  const shouldLinkToMigration = cloudApmMigrationEnabled && hasCloudAgentPolicy && !hasCloudApmPackagePolicy && hasRequiredRole;
  const apmIntegrationHref = shouldLinkToMigration ? `${basePath}/app/apm/settings/schema` : `${basePath}/app/integrations#/detail/apm/overview`;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }));
  }

  // When APM integration is enable in Fleet
  if (hasApmIntegrations) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmTutorialFleetInstructionsManageApmIntegrationInFleetButton",
      iconType: "gear",
      fill: true,
      href: `${basePath}/app/integrations/detail/apm/policies`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.apm.tutorial.apmServer.fleet.manageApmIntegration.button', {
      defaultMessage: 'Manage APM integration in Fleet'
    }));
  }
  // When APM integration is not installed in Fleet or for some reason the API didn't work out
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    textAlign: "left",
    title: _i18n.i18n.translate('xpack.apm.tutorial.apmServer.fleet.title', {
      defaultMessage: 'Elastic APM now available in Fleet!'
    }),
    description: _i18n.i18n.translate('xpack.apm.tutorial.apmServer.fleet.message', {
      defaultMessage: 'The APM integration installs Elasticsearch templates and ingest pipelines for APM data.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmTutorialFleetInstructionsApmIntegrationButton",
      iconType: "analyzeEvent",
      color: "success",
      href: apmIntegrationHref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.apm.tutorial.apmServer.fleet.apmIntegration.button', {
      defaultMessage: 'APM integration'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.apm.tutorial.apmServer.fleet.apmIntegration.description', {
      defaultMessage: 'Fleet allows you to centrally manage Elastic Agents running the APM integration. The default option is to install a Fleet Server on a dedicated host. For setups without a dedicated host, we recommend following the instructions to install the standalone APM Server for your operating system by selecting the respective tab above.'
    })))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: `${basePath}/plugins/kibanaReact/assets/${isDarkTheme ? 'illustration_integrations_darkmode.svg' : 'illustration_integrations_lightmode.svg'}`,
    alt: "Illustration",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }))));
}