"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceSample = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const traceSample = exports.traceSample = {
  traceItems: {
    exceedsMax: false,
    traceDocs: [{
      span: {
        name: 'POST',
        id: '06b480d1e6e2ac2e',
        subtype: 'http',
        type: 'external',
        duration: {
          us: 53170
        },
        destination: {
          service: {
            resource: 'frontend-proxy:8080'
          }
        },
        links: []
      },
      service: {
        name: 'load-generator'
      },
      transaction: {
        duration: {
          us: 53170
        },
        result: 'HTTP 2xx',
        type: 'external.http',
        id: '06b480d1e6e2ac2e',
        name: 'POST'
      },
      timestamp: {
        us: 1748348104973508
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/python'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'ingress',
        id: 'ca685f5c6799a9db',
        links: []
      },
      service: {
        name: 'frontend-proxy'
      },
      transaction: {
        duration: {
          us: 52317
        },
        result: 'Success',
        type: 'request',
        id: 'ca685f5c6799a9db',
        name: 'ingress'
      },
      timestamp: {
        us: 1748348104973768
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'otlp'
      },
      parent: {
        id: '06b480d1e6e2ac2e'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'router frontend egress',
        duration: {
          us: 52238
        },
        id: '2bc4a3e0c58202b2',
        subtype: 'http',
        type: 'external',
        links: []
      },
      timestamp: {
        us: 1748348104973810
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'frontend-proxy'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'otlp'
      },
      parent: {
        id: 'ca685f5c6799a9db'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST',
        id: '5ee78181bd675502',
        links: []
      },
      service: {
        name: 'frontend'
      },
      transaction: {
        duration: {
          us: 52050
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: '5ee78181bd675502',
        name: 'POST'
      },
      timestamp: {
        us: 1748348104973000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: '2bc4a3e0c58202b2'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST /api/checkout',
        id: 'dd5e527d60aed601',
        links: []
      },
      service: {
        name: 'frontend'
      },
      transaction: {
        duration: {
          us: 51852
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: 'dd5e527d60aed601',
        name: 'POST /api/checkout'
      },
      timestamp: {
        us: 1748348104974000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: '5ee78181bd675502'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'executing api route (pages) /api/checkout',
        duration: {
          us: 51298
        },
        id: '2b18312dfedbf16a',
        subtype: 'http',
        type: 'external',
        links: []
      },
      timestamp: {
        us: 1748348104974000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'frontend'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: 'dd5e527d60aed601'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'grpc.oteldemo.CheckoutService/PlaceOrder',
        id: 'b1992ac8f9ba616d',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 49516
        },
        destination: {
          service: {
            resource: 'checkout:5050'
          }
        },
        links: []
      },
      service: {
        name: 'frontend'
      },
      timestamp: {
        us: 1748348104974000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: '2b18312dfedbf16a'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.CheckoutService/PlaceOrder',
        id: '3e3c5ccfd752b92d',
        links: []
      },
      service: {
        name: 'checkout'
      },
      transaction: {
        duration: {
          us: 46643
        },
        result: 'OK',
        type: 'request',
        id: '3e3c5ccfd752b92d',
        name: 'oteldemo.CheckoutService/PlaceOrder'
      },
      timestamp: {
        us: 1748348104976629
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: 'b1992ac8f9ba616d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'HTTP POST',
        id: '0f458d9afc3b76ed',
        subtype: 'http',
        type: 'external',
        duration: {
          us: 16795
        },
        destination: {
          service: {
            resource: 'email:6060'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348105005416
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'prepareOrderItemsAndShippingQuoteFromCart',
        duration: {
          us: 12947
        },
        id: '495970b405cce0cf',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348104977096
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'checkout'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST /send_order_confirmation',
        id: '8130a1e6891de44e',
        links: []
      },
      service: {
        name: 'email'
      },
      transaction: {
        duration: {
          us: 9462
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: '8130a1e6891de44e',
        name: 'POST /send_order_confirmation'
      },
      timestamp: {
        us: 1748348105012500
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/ruby'
      },
      parent: {
        id: '0f458d9afc3b76ed'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.PaymentService/Charge',
        id: 'c926cd1ea7f7ae3a',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 8752
        },
        destination: {
          service: {
            resource: 'oteldemo.PaymentService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104990238
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'send_email',
        duration: {
          us: 8029
        },
        id: '9266e7aefde7553b',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105013749
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'email'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/ruby'
      },
      parent: {
        id: '8130a1e6891de44e'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ShippingService/GetQuote',
        id: 'f04159fe7ad90ba8',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 5886
        },
        destination: {
          service: {
            resource: 'oteldemo.ShippingService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104982910
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '495970b405cce0cf'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.CartService/EmptyCart',
        id: 'f1113f2aa04083df',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 5541
        },
        destination: {
          service: {
            resource: 'oteldemo.CartService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104999544
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST /oteldemo.CartService/EmptyCart',
        id: '7c3afb0f52b28be8',
        links: []
      },
      service: {
        name: 'cart'
      },
      transaction: {
        duration: {
          us: 5120
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: '7c3afb0f52b28be8',
        name: 'POST /oteldemo.CartService/EmptyCart'
      },
      timestamp: {
        us: 1748348104999837
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: 'f1113f2aa04083df'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ShippingService/GetQuote',
        id: 'fdf567fac603b802',
        links: []
      },
      service: {
        name: 'shipping'
      },
      transaction: {
        duration: {
          us: 4652
        },
        result: 'OK',
        type: 'request',
        id: 'fdf567fac603b802',
        name: 'oteldemo.ShippingService/GetQuote'
      },
      timestamp: {
        us: 1748348104983880
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/rust'
      },
      parent: {
        id: 'f04159fe7ad90ba8'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST',
        id: '4789437b821aac6e',
        subtype: 'http',
        type: 'external',
        duration: {
          us: 4362
        },
        destination: {
          service: {
            resource: 'quote:8090'
          }
        },
        links: []
      },
      service: {
        name: 'shipping'
      },
      timestamp: {
        us: 1748348104984083
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/rust'
      },
      parent: {
        id: 'fdf567fac603b802'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'grpc.oteldemo.PaymentService/Charge',
        id: 'edc89fefb75c1301',
        links: []
      },
      service: {
        name: 'payment'
      },
      transaction: {
        duration: {
          us: 2839
        },
        result: 'OK',
        type: 'request',
        id: 'edc89fefb75c1301',
        name: 'grpc.oteldemo.PaymentService/Charge'
      },
      timestamp: {
        us: 1748348104995000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: 'c926cd1ea7f7ae3a'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.CurrencyService/Convert',
        id: '7f73eb7123c3140c',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 2818
        },
        destination: {
          service: {
            resource: 'oteldemo.CurrencyService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104980052
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '495970b405cce0cf'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'flagd.evaluation.v1.Service/ResolveBoolean',
        id: 'a7c1d66a0cb57b89',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 2779
        },
        destination: {
          service: {
            resource: 'flagd:8013'
          }
        },
        links: []
      },
      service: {
        name: 'cart'
      },
      timestamp: {
        us: 1748348105001302
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: '7c3afb0f52b28be8'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.CartService/GetCart',
        id: 'b48a53801125b0c7',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 2085
        },
        destination: {
          service: {
            resource: 'oteldemo.CartService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104977222
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '495970b405cce0cf'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST',
        id: '70298b86e4dea067',
        subtype: 'http',
        type: 'external',
        duration: {
          us: 1982
        },
        destination: {
          service: {
            resource: 'flagd:8013'
          }
        },
        links: []
      },
      service: {
        name: 'cart'
      },
      timestamp: {
        us: 1748348105001901
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: 'a7c1d66a0cb57b89'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.CurrencyService/Convert',
        id: 'f52a2b1515c24938',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 1203
        },
        destination: {
          service: {
            resource: 'oteldemo.CurrencyService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104988825
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '495970b405cce0cf'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'charge',
        duration: {
          us: 1197
        },
        id: '50adea140292e7ca',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348104996000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'payment'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: 'edc89fefb75c1301'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'grpc.oteldemo.ProductCatalogService/GetProduct',
        id: '41b39c13ec0166a8',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 1187
        },
        destination: {
          service: {
            resource: 'product-catalog:3550'
          }
        },
        links: []
      },
      service: {
        name: 'frontend'
      },
      timestamp: {
        us: 1748348105024000
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/nodejs'
      },
      parent: {
        id: '2b18312dfedbf16a'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST /getquote',
        id: 'fd585fe05388def7',
        links: []
      },
      service: {
        name: 'quote'
      },
      transaction: {
        duration: {
          us: 1027
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: 'fd585fe05388def7',
        name: 'POST /getquote'
      },
      timestamp: {
        us: 1748348105006747
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/php/opentelemetry-php-instrumentation'
      },
      parent: {
        id: '4789437b821aac6e'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'Currency/Convert',
        id: 'a210ecef6a7d7e8d',
        links: []
      },
      service: {
        name: 'currency'
      },
      transaction: {
        duration: {
          us: 933
        },
        result: 'OK',
        type: 'request',
        id: 'a210ecef6a7d7e8d',
        name: 'Currency/Convert'
      },
      timestamp: {
        us: 1748348104981254
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/cpp'
      },
      parent: {
        id: '7f73eb7123c3140c'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'orders publish',
        id: 'ecb2bd70800fcd22',
        subtype: 'kafka',
        type: 'messaging',
        duration: {
          us: 812
        },
        destination: {
          service: {
            resource: 'kafka/orders'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348105022293
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'POST /oteldemo.CartService/GetCart',
        id: '763741dc550562ee',
        links: []
      },
      service: {
        name: 'cart'
      },
      transaction: {
        duration: {
          us: 594
        },
        result: 'HTTP 2xx',
        type: 'request',
        id: '763741dc550562ee',
        name: 'POST /oteldemo.CartService/GetCart'
      },
      timestamp: {
        us: 1748348104978330
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: 'b48a53801125b0c7'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ProductCatalogService/GetProduct',
        id: '3c3c0067e8d6066c',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 594
        },
        destination: {
          service: {
            resource: 'oteldemo.ProductCatalogService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104979431
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '495970b405cce0cf'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: '{closure}',
        duration: {
          us: 573
        },
        id: 'dd2a1a95734a02eb',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105007158
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'quote'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/php/opentelemetry-php-instrumentation'
      },
      parent: {
        id: 'fd585fe05388def7'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'sinatra.render_template',
        duration: {
          us: 558
        },
        id: '7f6fc3fd91db79c0',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105013797
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'email'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/ruby'
      },
      parent: {
        id: '9266e7aefde7553b'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'Currency/Convert',
        id: 'ca089fde8244c555',
        links: []
      },
      service: {
        name: 'currency'
      },
      transaction: {
        duration: {
          us: 501
        },
        result: 'OK',
        type: 'request',
        id: 'ca089fde8244c555',
        name: 'Currency/Convert'
      },
      timestamp: {
        us: 1748348104989091
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/cpp'
      },
      parent: {
        id: 'f52a2b1515c24938'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ShippingService/ShipOrder',
        id: '090e5f68de272201',
        subtype: 'grpc',
        type: 'external',
        duration: {
          us: 460
        },
        destination: {
          service: {
            resource: 'oteldemo.ShippingService'
          }
        },
        links: []
      },
      service: {
        name: 'checkout'
      },
      timestamp: {
        us: 1748348104999056
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3e3c5ccfd752b92d'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'HGET',
        id: 'fbefc18323ffd8f0',
        subtype: 'redis',
        type: 'db',
        duration: {
          us: 421
        },
        destination: {
          service: {
            resource: 'redis'
          }
        },
        links: []
      },
      service: {
        name: 'cart'
      },
      timestamp: {
        us: 1748348104978422
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: '763741dc550562ee'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'HMSET',
        id: '6bccc85b60bce445',
        subtype: 'redis',
        type: 'db',
        duration: {
          us: 324
        },
        destination: {
          service: {
            resource: 'redis'
          }
        },
        links: []
      },
      service: {
        name: 'cart'
      },
      timestamp: {
        us: 1748348105004299
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: '7c3afb0f52b28be8'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'EXPIRE',
        id: 'cb2837f27681f22c',
        subtype: 'redis',
        type: 'db',
        duration: {
          us: 211
        },
        destination: {
          service: {
            resource: 'redis'
          }
        },
        links: []
      },
      service: {
        name: 'cart'
      },
      timestamp: {
        us: 1748348105004680
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/dotnet'
      },
      parent: {
        id: '7c3afb0f52b28be8'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'sinatra.render_template',
        duration: {
          us: 176
        },
        id: '4bd53941bd2f1793',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105014097
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'email'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/ruby'
      },
      parent: {
        id: '7f6fc3fd91db79c0'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'calculate-quote',
        duration: {
          us: 150
        },
        id: 'b8fb340acf58cb6a',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105007297
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'quote'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/php/opentelemetry-php-instrumentation'
      },
      parent: {
        id: 'dd2a1a95734a02eb'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'flagd.evaluation.v1.Service/ResolveBoolean',
        id: 'e7abea9a78e4cbed',
        links: []
      },
      service: {
        name: 'flagd'
      },
      transaction: {
        duration: {
          us: 125
        },
        result: 'OK',
        type: 'request',
        id: 'e7abea9a78e4cbed',
        name: 'flagd.evaluation.v1.Service/ResolveBoolean'
      },
      timestamp: {
        us: 1748348105003021
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '70298b86e4dea067'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ProductCatalogService/GetProduct',
        id: '8bfd5febb26ea39d',
        links: []
      },
      service: {
        name: 'product-catalog'
      },
      transaction: {
        duration: {
          us: 94
        },
        result: 'OK',
        type: 'request',
        id: '8bfd5febb26ea39d',
        name: 'oteldemo.ProductCatalogService/GetProduct'
      },
      timestamp: {
        us: 1748348104979798
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '3c3c0067e8d6066c'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ProductCatalogService/GetProduct',
        id: '255547a7b6b19871',
        links: []
      },
      service: {
        name: 'product-catalog'
      },
      transaction: {
        duration: {
          us: 90
        },
        result: 'OK',
        type: 'request',
        id: '255547a7b6b19871',
        name: 'oteldemo.ProductCatalogService/GetProduct'
      },
      timestamp: {
        us: 1748348105025179
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: '41b39c13ec0166a8'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'resolveBoolean',
        duration: {
          us: 77
        },
        id: 'a45d85c1b2a34eed',
        type: 'unknown',
        links: []
      },
      timestamp: {
        us: 1748348105003039
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'flagd'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: 'e7abea9a78e4cbed'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'oteldemo.ShippingService/ShipOrder',
        id: '319b2d0e75e9fbec',
        links: []
      },
      service: {
        name: 'shipping'
      },
      transaction: {
        duration: {
          us: 23
        },
        result: 'OK',
        type: 'request',
        id: '319b2d0e75e9fbec',
        name: 'oteldemo.ShippingService/ShipOrder'
      },
      timestamp: {
        us: 1748348104999274
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      processor: {
        event: 'transaction'
      },
      agent: {
        name: 'opentelemetry/rust'
      },
      parent: {
        id: '090e5f68de272201'
      },
      event: {
        outcome: 'success'
      }
    }, {
      span: {
        name: 'resolveBoolean',
        duration: {
          us: 5
        },
        id: '5524636f6a472939',
        subtype: 'internal',
        type: 'app',
        links: []
      },
      timestamp: {
        us: 1748348105003049
      },
      trace: {
        id: 'cc847a76570773d6fc96fac63dfcddd2'
      },
      service: {
        name: 'flagd'
      },
      processor: {
        event: 'span'
      },
      agent: {
        name: 'opentelemetry/go'
      },
      parent: {
        id: 'a45d85c1b2a34eed'
      },
      event: {
        outcome: 'success'
      }
    }],
    errorDocs: [],
    spanLinksCountById: {
      ecb2bd70800fcd22: 2
    },
    traceDocsTotal: 46,
    maxTraceItems: 5000
  },
  entryTransaction: {
    transaction: {
      id: '06b480d1e6e2ac2e',
      duration: {
        us: 53170
      },
      name: 'POST',
      sampled: true,
      type: 'external.http'
    },
    timestamp: {
      us: 1748348104973508
    },
    trace: {
      id: 'cc847a76570773d6fc96fac63dfcddd2'
    },
    '@timestamp': '2025-05-27T12:15:04.973Z',
    service: {
      name: 'load-generator',
      language: {
        name: 'python'
      }
    },
    processor: {
      name: 'transaction',
      event: 'transaction'
    },
    agent: {
      name: 'opentelemetry/python'
    },
    server: {}
  }
};