"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TechnicalPreviewBadge = TechnicalPreviewBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/technical_preview_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TechnicalPreviewBadge({
  icon,
  size,
  style
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.apm.technicalPreviewBadgeLabel', {
      defaultMessage: 'Technical preview'
    }),
    "aria-label": _i18n.i18n.translate('xpack.apm.technicalPreviewBadge.ariaLabel', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.technicalPreviewBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    iconType: icon,
    size: size,
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
}