"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceDetails = ServiceDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/service_icons/service_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceDetails({
  service
}) {
  var _service$versions;
  if (!service) {
    return null;
  }
  const listItems = [];
  if (!!((_service$versions = service.versions) !== null && _service$versions !== void 0 && _service$versions.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.service.versionLabel', {
        defaultMessage: 'Service version'
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 9
        }
      }, service.versions.map((version, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 13
        }
      }, version)))
    });
  }
  if (service.runtime) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.service.runtimeLabel', {
        defaultMessage: 'Runtime name & version'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, service.runtime.name, " ", service.runtime.version)
    });
  }
  if (service.framework) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.service.frameworkLabel', {
        defaultMessage: 'Framework name'
      }),
      description: service.framework
    });
  }
  if (service.agent) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.service.agentLabel', {
        defaultMessage: 'Agent name & version'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, service.agent.name, " ", service.agent.version)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 10
    }
  });
}