"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorer = TraceExplorer;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _trace_explorer = require("../../../../common/trace_explorer");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _apm_date_picker = require("../../shared/date_picker/apm_date_picker");
var _url_helpers = require("../../shared/links/url_helpers");
var _trace_search_box = require("./trace_search_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/trace_explorer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TraceExplorer({
  children
}) {
  const [searchQuery, setSearchQuery] = (0, _react.useState)({
    query: '',
    type: _trace_explorer.TraceSearchType.kql
  });
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      query: queryFromUrlParams,
      type: typeFromUrlParams
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer');
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    setSearchQuery({
      query: queryFromUrlParams,
      type: typeFromUrlParams
    });
  }, [queryFromUrlParams, typeFromUrlParams]);
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const params = (0, _react.useMemo)(() => {
    return {
      query: {
        start,
        end,
        environment,
        query: queryFromUrlParams,
        type: typeFromUrlParams
      }
    };
  }, [start, end, environment, queryFromUrlParams, typeFromUrlParams]);
  return /*#__PURE__*/_react.default.createElement(_use_trace_explorer_samples.TraceExplorerSamplesFetcherContextProvider, {
    params: params,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_trace_search_box.TraceSearchBox, {
    query: searchQuery,
    error: false,
    loading: false,
    onQueryCommit: () => {
      (0, _url_helpers.push)(history, {
        query: {
          query: searchQuery.query,
          type: searchQuery.type
        }
      });
    },
    onQueryChange: nextQuery => {
      setSearchQuery(nextQuery);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_date_picker.ApmDatePicker, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, children)));
}