"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = SettingsPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _elasticAgentUtils = require("@kbn/elastic-agent-utils");
var _all_option = require("../../../../../../../common/agent_configuration/all_option");
var _setting_definitions = require("../../../../../../../common/agent_configuration/setting_definitions");
var _use_apm_plugin_context = require("../../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../../../hooks/use_fetcher");
var _save_config = require("./save_config");
var _setting_form_row = require("./setting_form_row");
var _advanced_configuration = require("./advanced_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/settings_page/settings_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function removeEmpty(obj) {
  return Object.fromEntries(Object.entries(obj).filter(([k, v]) => k !== '' && k != null && v !== '' && v != null));
}
function SettingsPage({
  initialConfig,
  unsavedChanges,
  newConfig,
  setNewConfig,
  resetSettings,
  isEditMode,
  onClickEdit
}) {
  const history = (0, _reactRouterDom.useHistory)();
  // get a telemetry UI event tracker
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [removedConfigCount, setRemovedConfigCount] = (0, _react.useState)(0);
  const [validationErrors, setValidationErrors] = (0, _react.useState)(new Map());
  const unsavedChangesCount = Object.keys(unsavedChanges).length;
  const status = initialConfig === null || initialConfig === void 0 ? void 0 : initialConfig.status;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isAdvancedConfigSupported = newConfig.agent_name && (0, _elasticAgentUtils.isEDOTAgentName)(newConfig.agent_name);
  const hasActiveValidationErrors = [...validationErrors.values()].includes(true);
  const hasInactiveValidationErrors = [...validationErrors.values()].includes(false);
  const [revalidate, setRevalidate] = (0, _react.useState)(false);
  const addValidationError = (0, _react.useCallback)((key, active) => {
    setValidationErrors(prev => {
      prev.set(key, active);
      return new Map(prev);
    });
  }, []);
  const removeValidationError = (0, _react.useCallback)(key => {
    setValidationErrors(prev => {
      prev.delete(key);
      return new Map(prev);
    });
  }, []);
  const settingsDefinitionsByAgent = (0, _react.useMemo)(() => _setting_definitions.settingDefinitions.filter((0, _setting_definitions.filterByAgent)(newConfig.agent_name)), [newConfig.agent_name]);
  const isFormValid = (0, _react.useMemo)(() => {
    return _setting_definitions.settingDefinitions
    // only validate settings that are not empty
    .filter(({
      key
    }) => {
      const value = newConfig.settings[key];
      return value != null && value !== '';
    })

    // every setting must be valid for the form to be valid
    .every(def => {
      const value = newConfig.settings[def.key];
      return (0, _setting_definitions.validateSetting)(def, value).isValid;
    });
  }, [newConfig.settings]);
  const handleSubmitEvent = async () => {
    if (hasInactiveValidationErrors) {
      setRevalidate(true);
      return;
    }
    trackApmEvent({
      metric: 'save_agent_configuration'
    });
    const config = {
      ...newConfig,
      settings: removeEmpty(newConfig.settings)
    };
    setIsSaving(true);
    await (0, _save_config.saveConfig)({
      config,
      isEditMode,
      toasts
    });
    setIsSaving(false);

    // go back to overview
    history.push({
      pathname: '/settings/agent-configuration',
      search: history.location.search
    });
  };
  const handleChange = (0, _react.useCallback)(({
    key,
    value,
    oldKey
  }) => {
    setNewConfig(prev => {
      let updatedSettings;
      if (oldKey !== undefined) {
        // Handle key change

        // Maintain the order by recreating the config object while preserving key positions
        updatedSettings = Object.fromEntries(Object.entries(prev.settings).map(([currentKey, currentValue]) => currentKey === oldKey ? [key, currentValue] : [currentKey, currentValue]));
      } else if (key === '' && value === '' && prev.settings[''] === undefined) {
        // Handle new row at the top of the list
        updatedSettings = {
          ['']: '',
          ...prev.settings
        };
      } else {
        // Handle value change
        updatedSettings = {
          ...prev.settings,
          [key]: value
        };
      }
      return {
        ...prev,
        settings: updatedSettings
      };
    });
  }, [setNewConfig]);
  const handleDelete = (key, id) => {
    var _initialConfig$data$s, _initialConfig$data;
    // Detect removed config only when the key-value already existed before
    if (key in ((_initialConfig$data$s = initialConfig === null || initialConfig === void 0 ? void 0 : (_initialConfig$data = initialConfig.data) === null || _initialConfig$data === void 0 ? void 0 : _initialConfig$data.settings) !== null && _initialConfig$data$s !== void 0 ? _initialConfig$data$s : {})) {
      setRemovedConfigCount(prev => prev + 1);
    }
    removeValidationError(`key${id}`);
    removeValidationError(`value${id}`);
    setNewConfig(prev => {
      const {
        [key]: deleted,
        ...rest
      } = prev.settings;
      return {
        ...prev,
        settings: rest
      };
    });
  };
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.notFound.title', {
        defaultMessage: 'Sorry, there was an error'
      }),
      color: "danger",
      iconType: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.notFound.message', {
      defaultMessage: 'The requested configuration does not exist'
    })));
  }
  const handleNewRow = () => {
    handleChange({
      key: '',
      value: ''
    });
    setRevalidate(false);
  };
  const handleDiscardChanges = () => {
    setRemovedConfigCount(0);
    setRevalidate(false);
    setValidationErrors(new Map());
    resetSettings();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("form", {
    onKeyPress: e => {
      const didClickEnter = e.which === 13;
      if (didClickEnter && isFormValid) {
        e.preventDefault();
        handleSubmitEvent();
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: isLoading ? '-' : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "settingsPage_serviceName",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 21
      }
    }, (0, _all_option.getOptionLabel)(newConfig.service.name)),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.service.name.label', {
      defaultMessage: 'Service name'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "xs",
    title: isLoading ? '-' : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "settingsPage_environmentName",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 21
      }
    }, (0, _all_option.getOptionLabel)(newConfig.service.environment)),
    description: _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.service.environment.label', {
      defaultMessage: 'Environment'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 13
    }
  }, !isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSettingsPageEditButton",
    onClick: onClickEdit,
    iconType: "pencil",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.agentConfig.chooseService.editButton', {
    defaultMessage: 'Edit'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 11
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderSettings({
    unsavedChanges,
    newConfig,
    settingsDefinitionsByAgent,
    onChange: handleChange
  }), isAdvancedConfigSupported && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_configuration.AdvancedConfiguration, {
    newConfig: newConfig,
    settingsDefinitions: settingsDefinitionsByAgent,
    revalidate: revalidate,
    onChange: handleChange,
    onDelete: handleDelete,
    addNewRow: handleNewRow,
    addValidationError: addValidationError,
    removeValidationError: removeValidationError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 7
    }
  }), (unsavedChangesCount > 0 || removedConfigCount > 0) && /*#__PURE__*/_react.default.createElement(_public.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: handleDiscardChanges,
    onSave: handleSubmitEvent,
    saveLabel: _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.saveButton', {
      defaultMessage: 'Save configuration'
    }),
    unsavedChangesCount: unsavedChangesCount + removedConfigCount,
    appTestSubj: "apm",
    areChangesInvalid: hasActiveValidationErrors || !isFormValid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }));
}
function renderSettings({
  newConfig,
  unsavedChanges,
  settingsDefinitionsByAgent,
  onChange
}) {
  return settingsDefinitionsByAgent.map(setting => /*#__PURE__*/_react.default.createElement(_setting_form_row.SettingFormRow, {
    isUnsaved: Object.hasOwn(unsavedChanges, setting.key),
    key: setting.key,
    setting: setting,
    value: newConfig.settings[setting.key],
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 5
    }
  }));
}