"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsButtonGroup = ServiceGroupsButtonGroup;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_groups_button_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const buttonGroupOptions = {
  allServices: {
    option: {
      id: 'allServices',
      label: _i18n.i18n.translate('xpack.apm.serviceGroups.buttonGroup.allServices', {
        defaultMessage: 'All services'
      })
    },
    pathname: '/services'
  },
  serviceGroups: {
    option: {
      id: 'serviceGroups',
      label: _i18n.i18n.translate('xpack.apm.serviceGroups.buttonGroup.serviceGroups', {
        defaultMessage: 'Service groups'
      })
    },
    pathname: '/service-groups'
  }
};
function ServiceGroupsButtonGroup({
  selectedNavButton
}) {
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    options: [buttonGroupOptions.allServices.option, buttonGroupOptions.serviceGroups.option],
    idSelected: selectedNavButton,
    onChange: id => {
      const {
        pathname
      } = buttonGroupOptions[id];
      history.push({
        pathname
      });
    },
    legend: _i18n.i18n.translate('xpack.apm.servicesGroups.buttonGroup.legend', {
      defaultMessage: 'View all services or service groups'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
}