"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNodeMetrics = ServiceNodeMetrics;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireDefault(require("react"));
var _document_type = require("../../../../../common/document_type");
var _service_nodes = require("../../../../../common/service_nodes");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _use_service_metric_charts_fetcher = require("../../../../hooks/use_service_metric_charts_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _style = require("../../../../utils/style");
var _metrics_chart = require("../../../shared/charts/metrics_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics_details/service_node_metrics/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_DATA = {
  host: '',
  containerId: ''
};
const Truncate = _styled.default.span`
  display: block;
  ${(0, _style.truncate)(_style.unit * 12)}
`;
function ServiceNodeMetrics({
  serviceNodeName
}) {
  const {
    agentName,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics/{id}');
  const {
    environment,
    kuery,
    rangeFrom,
    rangeTo
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title: (0, _service_nodes.getServiceNodeName)(serviceNodeName),
    href: apmRouter.link('/services/{serviceName}/metrics/{id}', {
      path: {
        serviceName,
        id: serviceNodeName
      },
      query
    })
  }), [apmRouter, query, serviceName, serviceNodeName]);
  const {
    data
  } = (0, _use_service_metric_charts_fetcher.useServiceMetricChartsFetcher)({
    serviceNodeName,
    kuery,
    environment
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric,
    numBuckets: 100
  });
  const {
    data: {
      host,
      containerId
    } = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && preferred) {
      return callApmApi('GET /internal/apm/services/{serviceName}/node/{serviceNodeName}/metadata', {
        params: {
          path: {
            serviceName,
            serviceNodeName
          },
          query: {
            kuery,
            start,
            end,
            environment,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval
          }
        }
      });
    }
  }, [kuery, serviceName, serviceNodeName, start, end, environment, preferred]);
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isAggregatedData = serviceNodeName === _service_nodes.SERVICE_NODE_NAME_MISSING;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAggregatedData ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.serviceNodeMetrics.unidentifiedServiceNodesWarningTitle', {
      defaultMessage: 'Could not identify JVMs'
    }),
    iconType: "question",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.serviceNodeMetrics.unidentifiedServiceNodesWarningText",
    defaultMessage: "We could not identify which JVMs these metrics belong to. This is likely caused by running a version of APM Server that is older than 7.5. Upgrading to APM Server 7.5 or higher should resolve this issue. For more information on upgrading, see the {link}. As an alternative, you can use the Kibana Query bar to filter by hostname, container ID or other fields.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmServiceNodeMetricsDocumentationOfApmServerLink",
        href: docLinks.links.apm.upgrading,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.apm.serviceNodeMetrics.unidentifiedServiceNodesWarningDocumentationLink', {
        defaultMessage: 'documentation of APM Server'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: 'none',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serviceNodeMetrics.serviceName', {
      defaultMessage: 'Service name'
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: serviceName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(Truncate, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 21
      }
    }, serviceName)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "s",
    isLoading: isLoading,
    description: _i18n.i18n.translate('xpack.apm.serviceNodeMetrics.host', {
      defaultMessage: 'Host'
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: host,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(Truncate, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 21
      }
    }, host)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleSize: "s",
    isLoading: isLoading,
    description: _i18n.i18n.translate('xpack.apm.serviceNodeMetrics.containerId', {
      defaultMessage: 'Container ID'
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: containerId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(Truncate, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 21
      }
    }, containerId)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoObservability",
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.apm.serviceMetrics.loading', {
      defaultMessage: 'Loading metrics'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }), agentName && /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, data.charts.map(chart => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chart.key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics_chart.MetricsChart, {
    start: start,
    end: end,
    chart: chart,
    fetchStatus: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  })));
}