"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsPopover = FieldStatsPopover;
exports.FieldStatsPopoverContent = FieldStatsPopoverContent;
exports.kqlQuery = kqlQuery;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _field_stats = require("@kbn/unified-field-list/src/components/field_stats");
var _field_popover = require("@kbn/unified-field-list/src/components/field_popover");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react2 = require("@emotion/react");
var _term_query = require("../../../../../common/utils/term_query");
var _apm = require("../../../../../common/es_fields/apm");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetch_params = require("../use_fetch_params");
var _use_adhoc_apm_data_view = require("../../../../hooks/use_adhoc_apm_data_view");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/correlations/context_popover/field_stats_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HIGHLIGHTED_BUCKET_PROPS = {
  color: 'accent',
  textProps: {
    color: 'accent'
  }
};
function kqlQuery(kql) {
  return !!kql ? [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kql))] : [];
}
function FieldStatsPopoverContent({
  fieldName,
  fieldValue,
  services,
  field,
  dataView,
  dslQuery,
  filters,
  fromDate,
  toDate,
  onAddFilter,
  overrideFieldTopValueBar
}) {
  const [needToFetchIndividualStat, setNeedToFetchIndividualStat] = (0, _react.useState)(false);
  const onStateChange = (0, _react.useCallback)(nextState => {
    const {
      topValues
    } = nextState;
    const idxToHighlight = Array.isArray(topValues) ? topValues.findIndex(value => value.key === fieldValue) : null;
    setNeedToFetchIndividualStat(idxToHighlight === -1 && fieldName !== undefined && fieldValue !== undefined);
  }, [fieldName, fieldValue]);
  const params = (0, _use_fetch_params.useFetchParams)();
  const {
    data: fieldValueStats,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (needToFetchIndividualStat) {
      return callApmApi('GET /internal/apm/correlations/field_value_stats/transactions', {
        params: {
          query: {
            ...params,
            fieldName,
            fieldValue,
            // Using sampler shard size to match with unified field list's default
            samplerShardSize: '5000'
          }
        }
      });
    }
  }, [params, fieldName, fieldValue, needToFetchIndividualStat]);
  const progressBarMax = fieldValueStats === null || fieldValueStats === void 0 ? void 0 : fieldValueStats.topValuesSampleSize;
  const formatter = dataView.getFormatterForField(field);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_stats.FieldStats, {
    services: services,
    field: field,
    dataViewOrDataViewId: dataView,
    dslQuery: dslQuery,
    fromDate: fromDate,
    toDate: toDate,
    onAddFilter: onAddFilter,
    overrideFieldTopValueBar: overrideFieldTopValueBar,
    onStateChange: onStateChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }), needToFetchIndividualStat ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.fieldContextPopover.notTopTenValueMessage",
    defaultMessage: "Selected term is not in the top 10",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }), status === _use_fetcher.FETCH_STATUS.SUCCESS && Array.isArray(fieldValueStats === null || fieldValueStats === void 0 ? void 0 : fieldValueStats.topValues) ? fieldValueStats === null || fieldValueStats === void 0 ? void 0 : fieldValueStats.topValues.map(value => {
    if (progressBarMax === undefined) return null;
    const formatted = formatter.convert(fieldValue);
    const decimal = value.doc_count / progressBarMax;
    const valueText = progressBarMax !== undefined ? (0, _numeral.default)(decimal).format('0.0%') : '';
    return /*#__PURE__*/_react.default.createElement(_field_stats.FieldTopValuesBucket, (0, _extends2.default)({
      field: field,
      fieldValue: fieldValue,
      formattedPercentage: valueText,
      formattedFieldValue: formatted,
      progressValue: decimal,
      count: value.doc_count,
      onAddFilter: onAddFilter,
      overrideFieldTopValueBar: overrideFieldTopValueBar,
      'data-test-subj': 'apmNotInTopTenFieldTopValueBucket'
    }, HIGHLIGHTED_BUCKET_PROPS, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    }));
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }))) : null);
}
function FieldStatsPopover({
  fieldName,
  fieldValue,
  onAddFilter
}) {
  const {
    query: {
      kuery: kql
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_fetch_params.useFetchParams)();
  const {
    data,
    core: {
      uiSettings
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const {
    services: {
      fieldFormats,
      charts
    }
  } = (0, _public.useKibana)();
  const [infoIsOpen, setInfoOpen] = (0, _react.useState)(false);
  const field = dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(fieldName);
  const closePopover = (0, _react.useCallback)(() => setInfoOpen(false), []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const params = (0, _use_fetch_params.useFetchParams)();
  const fieldStatsQuery = (0, _react.useMemo)(() => {
    const dslQuery = kqlQuery(kql);
    return {
      bool: {
        filter: [...(0, _term_query.termQuery)(_apm.SERVICE_NAME, params.serviceName), ...(0, _term_query.termQuery)(_apm.TRANSACTION_TYPE, params.transactionType), ...(0, _term_query.termQuery)(_apm.TRANSACTION_NAME, params.transactionName), ...dslQuery]
      }
    };
  }, [params, kql]);
  const fieldStatsServices = (0, _react.useMemo)(() => ({
    uiSettings,
    dataViews: data.dataViews,
    data,
    fieldFormats,
    charts
  }), [uiSettings, data, fieldFormats, charts]);
  const addFilter = (0, _react.useCallback)((popoverField, value, type) => {
    if (popoverField !== '_exists_' && (typeof value === 'number' || typeof value === 'string')) {
      onAddFilter({
        fieldName: popoverField.name,
        fieldValue: value,
        include: type === '+'
      });
    }
  }, [onAddFilter]);
  const overrideFieldTopValueBar = (0, _react.useCallback)(fieldTopValuesBucketParams => {
    if (fieldTopValuesBucketParams.type === 'other') {
      return {
        color: 'primary'
      };
    }
    return fieldValue === fieldTopValuesBucketParams.fieldValue ? HIGHLIGHTED_BUCKET_PROPS : {};
  }, [fieldValue]);
  if (!fieldFormats || !charts || !field || !dataView) return null;
  const trigger = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.correlations.fieldContextPopover.descriptionTooltipContent', {
      defaultMessage: 'Show top 10 field values for {fieldName}',
      values: {
        fieldName
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "inspect",
    onClick: ev => {
      setInfoOpen(!infoIsOpen);
    },
    "aria-label": _i18n.i18n.translate('xpack.apm.correlations.fieldContextPopover.topFieldValuesAriaLabel', {
      defaultMessage: 'Show top 10 field values for {fieldName}',
      values: {
        fieldName
      }
    }),
    "data-test-subj": 'apmCorrelationsContextPopoverButton',
    css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_field_popover.FieldPopover, {
    isOpen: infoIsOpen,
    closePopover: closePopover,
    button: trigger,
    renderHeader: () => /*#__PURE__*/_react.default.createElement(_field_popover.FieldPopoverHeader, {
      field: field,
      closePopover: closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 27
      }
    }),
    renderContent: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FieldStatsPopoverContent, {
      fieldName: fieldName,
      fieldValue: fieldValue,
      services: fieldStatsServices,
      field: field,
      dataView: dataView,
      dslQuery: fieldStatsQuery,
      fromDate: start,
      toDate: end,
      onAddFilter: addFilter,
      overrideFieldTopValueBar: overrideFieldTopValueBar,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 5
    }
  });
}