/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.util.ArrayList;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.xcontent.XContentFactory;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class AbstractNumericTestCase
extends ESIntegTestCase {
    protected static long minValue;
    protected static long maxValue;
    protected static long minValues;
    protected static long maxValues;

    @Override
    public void setupSuiteScopeCluster() throws Exception {
        int i;
        this.createIndex("idx");
        this.createIndex("idx_unmapped");
        ArrayList<Object> builders = new ArrayList<IndexRequestBuilder>();
        int numDocs = 10;
        for (i = 0; i < 10; ++i) {
            builders.add(AbstractNumericTestCase.prepareIndex("idx").setId(String.valueOf(i)).setSource(XContentFactory.jsonBuilder().startObject().field("value", i + 1).startArray("values").value(i + 2).value(i + 3).endArray().endObject()));
        }
        minValue = 1L;
        minValues = 2L;
        maxValue = 10L;
        maxValues = 12L;
        this.indexRandom(true, builders);
        this.prepareCreate("empty_bucket_idx").setMapping(new String[]{"value", "type=integer"}).get();
        builders = new ArrayList();
        for (i = 0; i < 2; ++i) {
            builders.add(AbstractNumericTestCase.prepareIndex("empty_bucket_idx").setId(String.valueOf(i)).setSource(XContentFactory.jsonBuilder().startObject().field("value", i * 2).endObject()));
        }
        this.indexRandom(true, builders);
        this.ensureSearchable(new String[0]);
    }

    public void testEmptyAggregation() throws Exception {
    }

    public void testUnmapped() throws Exception {
    }

    public void testSingleValuedField() throws Exception {
    }

    public void testSingleValuedFieldGetProperty() throws Exception {
    }

    public void testSingleValuedFieldPartiallyUnmapped() throws Exception {
    }

    public void testSingleValuedFieldWithValueScript() throws Exception {
    }

    public void testSingleValuedFieldWithValueScriptWithParams() throws Exception {
    }

    public void testMultiValuedField() throws Exception {
    }

    public void testMultiValuedFieldWithValueScript() throws Exception {
    }

    public void testMultiValuedFieldWithValueScriptWithParams() throws Exception {
    }

    public void testScriptSingleValued() throws Exception {
    }

    public void testScriptSingleValuedWithParams() throws Exception {
    }

    public void testScriptMultiValued() throws Exception {
    }

    public void testScriptMultiValuedWithParams() throws Exception {
    }

    public void testOrderByEmptyAggregation() throws Exception {
    }
}

