/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.LuceneQueryEvaluator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;

public class LuceneQueryExpressionEvaluator
extends LuceneQueryEvaluator<BooleanBlock.Builder>
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LuceneQueryExpressionEvaluator.class);

    LuceneQueryExpressionEvaluator(BlockFactory blockFactory, LuceneQueryEvaluator.ShardConfig[] shards) {
        super(blockFactory, shards);
    }

    @Override
    public Block eval(Page page) {
        return this.executeQuery(page);
    }

    @Override
    protected ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected Block createNoMatchBlock(BlockFactory blockFactory, int size) {
        return blockFactory.newConstantBooleanBlockWith(false, size);
    }

    @Override
    protected BooleanBlock.Builder createBlockBuilder(BlockFactory blockFactory, int size) {
        return blockFactory.newBooleanBlockBuilder(size);
    }

    @Override
    protected void appendNoMatch(BooleanBlock.Builder builder) {
        builder.appendBoolean(false);
    }

    @Override
    protected void appendMatch(BooleanBlock.Builder builder, Scorable scorer) throws IOException {
        builder.appendBoolean(true);
    }

    @Override
    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    public record Factory(LuceneQueryEvaluator.ShardConfig[] shardConfigs) implements EvalOperator.ExpressionEvaluator.Factory
    {
        @Override
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new LuceneQueryExpressionEvaluator(context.blockFactory(), this.shardConfigs);
        }
    }
}

