/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.functionscore.ScriptScoreQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.rescore.ScriptRescorer;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ScriptRescorerBuilder
extends RescorerBuilder<ScriptRescorerBuilder> {
    public static final String NAME = "script";
    private static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("script", false, Builder::new);
    private static final TransportVersion SCRIPT_RESCORER = TransportVersion.fromName("script_rescorer");
    private final Script script;
    private final QueryBuilder queryBuilder;

    public static ScriptRescorerBuilder fromXContent(XContentParser parser) throws IOException {
        return ((Builder)PARSER.parse(parser, null)).build();
    }

    public ScriptRescorerBuilder(Script script, QueryBuilder queryBuilder) {
        this.script = script;
        this.queryBuilder = queryBuilder;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    public ScriptRescorerBuilder(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.queryBuilder = new ScriptScoreQueryBuilder(new MatchAllQueryBuilder(), this.script);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
        builder.endObject();
    }

    @Override
    protected RescoreContext innerBuildContext(int windowSize, SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[script] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        ParsedQuery parsedQuery = context.toQuery(this.queryBuilder);
        ScriptRescorer.ScriptRescoreContext scriptRescoreContext = new ScriptRescorer.ScriptRescoreContext(parsedQuery, windowSize);
        return scriptRescoreContext;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return SCRIPT_RESCORER;
    }

    @Override
    public ScriptRescorerBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryBuilder rewrittenQueryBuilder = this.queryBuilder.rewrite(ctx);
        if (rewrittenQueryBuilder == this.queryBuilder) {
            return this;
        }
        ScriptRescorerBuilder rewritten = new ScriptRescorerBuilder(this.script, rewrittenQueryBuilder);
        if (this.windowSize() != null) {
            rewritten.windowSize(this.windowSize());
        }
        return rewritten;
    }

    static {
        PARSER.declareObject(Builder::setScript, (p, c) -> Script.parse(p), SCRIPT_FIELD);
    }

    static class Builder {
        private Script script;

        Builder() {
        }

        public void setScript(Script script) {
            this.script = script;
        }

        ScriptRescorerBuilder build() {
            ScriptScoreQueryBuilder queryBuilder = new ScriptScoreQueryBuilder(new MatchAllQueryBuilder(), this.script);
            return new ScriptRescorerBuilder(this.script, queryBuilder);
        }
    }
}

