/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Flow;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockConverseUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.completion.AmazonBedrockChatCompletionResponseListener;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;

public class AmazonBedrockChatCompletionRequest
extends AmazonBedrockRequest {
    public static final String USER_ROLE = "user";
    private final AmazonBedrockConverseRequestEntity requestEntity;
    private AmazonBedrockChatCompletionResponseListener listener;
    private final boolean stream;

    public AmazonBedrockChatCompletionRequest(AmazonBedrockChatCompletionModel model, AmazonBedrockConverseRequestEntity requestEntity, @Nullable TimeValue timeout, boolean stream) {
        super(model, timeout);
        this.requestEntity = Objects.requireNonNull(requestEntity);
        this.stream = stream;
    }

    @Override
    protected void executeRequest(AmazonBedrockBaseClient client) {
        ConverseRequest converseRequest = this.getConverseRequest();
        try {
            SocketAccess.doPrivileged(() -> client.converse(converseRequest, this.listener));
        }
        catch (IOException e) {
            this.listener.onFailure(new RuntimeException(e));
        }
    }

    @Override
    public TaskType taskType() {
        return TaskType.COMPLETION;
    }

    private ConverseRequest getConverseRequest() {
        ConverseRequest.Builder converseRequest = ConverseRequest.builder().modelId(this.amazonBedrockModel.model()).messages(AmazonBedrockConverseUtils.getConverseMessageList(this.requestEntity.messages())).additionalModelResponseFieldPaths(this.requestEntity.additionalModelFields());
        AmazonBedrockConverseUtils.inferenceConfig(this.requestEntity).ifPresent(arg_0 -> ((ConverseRequest.Builder)converseRequest).inferenceConfig(arg_0));
        if (this.requestEntity.additionalModelFields() != null) {
            converseRequest.additionalModelResponseFieldPaths(this.requestEntity.additionalModelFields());
        }
        return (ConverseRequest)converseRequest.build();
    }

    public void executeChatCompletionRequest(AmazonBedrockBaseClient awsBedrockClient, AmazonBedrockChatCompletionResponseListener chatCompletionResponseListener) {
        this.listener = chatCompletionResponseListener;
        this.executeRequest(awsBedrockClient);
    }

    public Flow.Publisher<? extends InferenceServiceResults.Result> executeStreamChatCompletionRequest(AmazonBedrockBaseClient awsBedrockClient) {
        ConverseStreamRequest.Builder converseStreamRequest = ConverseStreamRequest.builder().modelId(this.amazonBedrockModel.model()).messages(AmazonBedrockConverseUtils.getConverseMessageList(this.requestEntity.messages()));
        AmazonBedrockConverseUtils.inferenceConfig(this.requestEntity).ifPresent(arg_0 -> ((ConverseStreamRequest.Builder)converseStreamRequest).inferenceConfig(arg_0));
        if (this.requestEntity.additionalModelFields() != null) {
            converseStreamRequest.additionalModelResponseFieldPaths(this.requestEntity.additionalModelFields());
        }
        return awsBedrockClient.converseStream((ConverseStreamRequest)converseStreamRequest.build());
    }

    @Override
    public boolean isStreaming() {
        return this.stream;
    }
}

