/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkRequestParser;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.transport.RawIndexingDataTransportRequest;
import org.elasticsearch.xcontent.XContentType;

public class BulkRequest
extends LegacyActionRequest
implements CompositeIndicesRequest,
WriteRequest<BulkRequest>,
Accountable,
RawIndexingDataTransportRequest {
    private static final TransportVersion STREAMS_ENDPOINT_PARAM_RESTRICTIONS = TransportVersion.fromName("streams_endpoint_param_restrictions");
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BulkRequest.class);
    private static final int REQUEST_OVERHEAD = 50;
    final List<DocWriteRequest<?>> requests = new ArrayList();
    private final Set<String> indices = new HashSet<String>();
    protected TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private IncrementalState incrementalState = IncrementalState.EMPTY;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private String globalPipeline;
    private String globalRouting;
    private String globalIndex;
    private Boolean globalRequireAlias;
    private Boolean globalRequireDatsStream;
    private boolean includeSourceOnError = true;
    private Set<String> paramsUsed = Collections.emptySet();
    private long sizeInBytes = 0L;

    public BulkRequest() {
    }

    public BulkRequest(StreamInput in) throws IOException {
        super(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.requests.addAll(in.readCollectionAsList(i -> DocWriteRequest.readDocumentRequest(null, i)));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.timeout = in.readTimeValue();
        for (DocWriteRequest<?> request : this.requests) {
            this.indices.add(Objects.requireNonNull(request.index(), "request index must not be null"));
        }
        this.incrementalState = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? new IncrementalState(in) : IncrementalState.EMPTY;
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            this.includeSourceOnError = in.readBoolean();
        }
        if (in.getTransportVersion().supports(STREAMS_ENDPOINT_PARAM_RESTRICTIONS)) {
            this.paramsUsed = in.readCollectionAsImmutableSet(StreamInput::readString);
        }
    }

    public BulkRequest(@Nullable String globalIndex) {
        this.globalIndex = globalIndex;
    }

    public BulkRequest add(DocWriteRequest<?> ... requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(DocWriteRequest<?> request) {
        if (request instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)request;
            this.add(indexRequest);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            this.add(deleteRequest);
        } else if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            this.add(updateRequest);
        } else {
            throw new IllegalArgumentException("No support for request [" + String.valueOf(request) + "]");
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(Iterable<DocWriteRequest<?>> requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        return this.internalAdd(request);
    }

    BulkRequest internalAdd(IndexRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        this.sizeInBytes += (long)(request.indexSource().byteLength() + 50);
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(UpdateRequest request) {
        return this.internalAdd(request);
    }

    BulkRequest internalAdd(UpdateRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        if (request.doc() != null) {
            this.sizeInBytes += (long)request.doc().indexSource().byteLength();
        }
        if (request.upsertRequest() != null) {
            this.sizeInBytes += (long)request.upsertRequest().indexSource().byteLength();
        }
        if (request.script() != null) {
            this.sizeInBytes += (long)(request.script().getIdOrCode().length() * 2);
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        this.sizeInBytes += 50L;
        this.indices.add(request.index());
        return this;
    }

    public List<DocWriteRequest<?>> requests() {
        return this.requests;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    public BulkRequest add(byte[] data, int from, int length, XContentType xContentType) throws IOException {
        return this.add(data, from, length, null, xContentType);
    }

    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) throws IOException {
        return this.add(new BytesArray(data, from, length), defaultIndex, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, null, null, null, null, null, null, true, xContentType, RestApiVersion.current());
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, null, null, null, null, null, null, allowExplicitIndex, xContentType, RestApiVersion.current());
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, @Nullable Boolean defaultRequireDataStream, @Nullable Boolean defaultListExecutedPipelines, boolean allowExplicitIndex, XContentType xContentType, RestApiVersion restApiVersion) throws IOException {
        String routing = BulkRequest.valueOrDefault(defaultRouting, this.globalRouting);
        String pipeline = BulkRequest.valueOrDefault(defaultPipeline, this.globalPipeline);
        Boolean requireAlias = BulkRequest.valueOrDefault(defaultRequireAlias, this.globalRequireAlias);
        Boolean requireDataStream = BulkRequest.valueOrDefault(defaultRequireDataStream, this.globalRequireDatsStream);
        new BulkRequestParser(true, this.includeSourceOnError, restApiVersion).parse(data, defaultIndex, routing, defaultFetchSourceContext, pipeline, requireAlias, requireDataStream, defaultListExecutedPipelines, allowExplicitIndex, xContentType, (indexRequest, type) -> this.internalAdd((IndexRequest)indexRequest), this::internalAdd, this::add);
        return this;
    }

    public BulkRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public BulkRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public BulkRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public final BulkRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public void incrementalState(IncrementalState incrementalState) {
        this.incrementalState = incrementalState;
    }

    public final BulkRequest includeSourceOnError(boolean includeSourceOnError) {
        this.includeSourceOnError = includeSourceOnError;
        return this;
    }

    public final BulkRequest pipeline(String globalPipeline) {
        this.globalPipeline = globalPipeline;
        return this;
    }

    public final BulkRequest routing(String globalRouting) {
        this.globalRouting = globalRouting;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public IncrementalState incrementalState() {
        return this.incrementalState;
    }

    public String pipeline() {
        return this.globalPipeline;
    }

    public String routing() {
        return this.globalRouting;
    }

    public Boolean requireAlias() {
        return this.globalRequireAlias;
    }

    public Boolean requireDataStream() {
        return this.globalRequireDatsStream;
    }

    public boolean includeSourceOnError() {
        return this.includeSourceOnError;
    }

    public BulkRequest requireAlias(Boolean globalRequireAlias) {
        this.globalRequireAlias = globalRequireAlias;
        return this;
    }

    public BulkRequest requireDataStream(Boolean globalRequireDatsStream) {
        this.globalRequireDatsStream = globalRequireDatsStream;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (DocWriteRequest<?> request : this.requests) {
            ActionRequestValidationException ex;
            if (((WriteRequest)((Object)request)).getRefreshPolicy() != WriteRequest.RefreshPolicy.NONE) {
                validationException = ValidateActions.addValidationError("RefreshPolicy is not supported on an item request. Set it on the BulkRequest instead.", validationException);
            }
            if ((ex = ((WriteRequest)((Object)request)).validate()) == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeCollection(this.requests, DocWriteRequest::writeDocumentRequest);
        this.refreshPolicy.writeTo(out);
        out.writeTimeValue(this.timeout);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            this.incrementalState.writeTo(out);
        }
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(this.includeSourceOnError);
        }
        if (out.getTransportVersion().supports(STREAMS_ENDPOINT_PARAM_RESTRICTIONS)) {
            out.writeCollection(this.paramsUsed, StreamOutput::writeString);
        }
    }

    @Override
    public String getDescription() {
        return "requests[" + this.requests.size() + "], indices[" + Strings.collectionToDelimitedString(this.indices, ", ") + "]";
    }

    private void applyGlobalMandatoryParameters(DocWriteRequest<?> request) {
        request.index(BulkRequest.valueOrDefault(request.index(), this.globalIndex));
    }

    private static String valueOrDefault(String value, String globalDefault) {
        if (Strings.isNullOrEmpty(value) && !Strings.isNullOrEmpty(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static Boolean valueOrDefault(Boolean value, Boolean globalDefault) {
        if (Objects.isNull(value) && !Objects.isNull(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.requests.stream().mapToLong(Accountable::ramBytesUsed).sum();
    }

    public Set<String> getIndices() {
        return Collections.unmodifiableSet(this.indices);
    }

    public boolean isSimulated() {
        return false;
    }

    public Set<String> requestParamsUsed() {
        return this.paramsUsed;
    }

    public void requestParamsUsed(Set<String> paramsUsed) {
        this.paramsUsed = paramsUsed;
    }

    public Map<String, ComponentTemplate> getComponentTemplateSubstitutions() throws IOException {
        return Map.of();
    }

    public Map<String, ComposableIndexTemplate> getIndexTemplateSubstitutions() throws IOException {
        return Map.of();
    }

    public BulkRequest shallowClone() {
        BulkRequest bulkRequest = new BulkRequest(this.globalIndex);
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        bulkRequest.waitForActiveShards(this.waitForActiveShards());
        bulkRequest.timeout(this.timeout());
        bulkRequest.pipeline(this.pipeline());
        bulkRequest.routing(this.routing());
        bulkRequest.requireAlias(this.requireAlias());
        bulkRequest.requireDataStream(this.requireDataStream());
        bulkRequest.requestParamsUsed(this.requestParamsUsed());
        return bulkRequest;
    }

    record IncrementalState(Map<ShardId, Exception> shardLevelFailures, boolean indexingPressureAccounted) implements Writeable
    {
        static final IncrementalState EMPTY = new IncrementalState(Collections.emptyMap(), false);

        IncrementalState(StreamInput in) throws IOException {
            this(in.readMap(ShardId::new, input -> input.readException()), false);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.shardLevelFailures, (o, s) -> s.writeTo(o), StreamOutput::writeException);
        }
    }
}

