/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public abstract class AbstractExponentialHistogram
implements ExponentialHistogram {
    @Override
    public long valueCount() {
        return this.zeroBucket().count() + this.negativeBuckets().valueCount() + this.positiveBuckets().valueCount();
    }

    public int hashCode() {
        return ExponentialHistogram.hashCode(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExponentialHistogram) {
            return ExponentialHistogram.equals(this, (ExponentialHistogram)obj);
        }
        return false;
    }

    public String toString() {
        CopyableBucketIterator pos;
        CopyableBucketIterator neg;
        StringBuilder sb = new StringBuilder(this.getClassNameWithoutPackage()).append("{");
        sb.append("scale=").append(this.scale());
        sb.append(", sum=").append(this.sum());
        sb.append(", valueCount=").append(this.valueCount());
        sb.append(", min=").append(this.min());
        sb.append(", max=").append(this.max());
        ZeroBucket zb = this.zeroBucket();
        if (zb.zeroThreshold() != 0.0) {
            sb.append(", zeroThreshold=").append(zb.zeroThreshold());
        }
        if (zb.count() != 0L) {
            sb.append(", zeroCount=").append(zb.count());
        }
        if ((neg = this.negativeBuckets().iterator()).hasNext()) {
            sb.append(", negative=[");
            AbstractExponentialHistogram.appendsBucketsAsString(sb, neg);
            sb.append("]");
        }
        if ((pos = this.positiveBuckets().iterator()).hasNext()) {
            sb.append(", positive=[");
            AbstractExponentialHistogram.appendsBucketsAsString(sb, pos);
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private String getClassNameWithoutPackage() {
        String fqn = this.getClass().getName();
        int lastDot = fqn.lastIndexOf(46);
        return fqn.substring(lastDot + 1);
    }

    private static void appendsBucketsAsString(StringBuilder out, BucketIterator it) {
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(it.peekIndex()).append(": ").append(it.peekCount());
            it.advance();
        }
    }
}

