/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.history;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class SnapshotLifecycleTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 7;
    public static final String SLM_TEMPLATE_VERSION_VARIABLE = "xpack.slm.template.version";
    public static final String SLM_TEMPLATE_NAME = ".slm-history-7";
    public static final String SLM_POLICY_NAME = "slm-history-ilm-policy";
    private final boolean slmHistoryEnabled;
    public static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = SnapshotLifecycleTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".slm-history-7", "/slm-history.json", 7, "xpack.slm.template.version")});
    private static final List<LifecyclePolicyConfig> LIFECYCLE_POLICY_CONFIGS = List.of(new LifecyclePolicyConfig("slm-history-ilm-policy", "/slm-history-ilm-policy.json"));

    protected boolean requiresMasterNode() {
        return true;
    }

    public SnapshotLifecycleTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.slmHistoryEnabled = (Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (!this.slmHistoryEnabled) {
            return Map.of();
        }
        return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (!this.slmHistoryEnabled) {
            return Collections.emptyList();
        }
        return this.lifecyclePolicies;
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return LIFECYCLE_POLICY_CONFIGS;
    }

    protected String getOrigin() {
        return "index_lifecycle";
    }
}

