/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class LongBytesRefState
implements AggregatorState {
    private long v1;
    private final BreakingBytesRefBuilder v2;
    private boolean seen;

    LongBytesRefState(long v1, BytesRef v2, CircuitBreaker breaker, String label) {
        this.v1 = v1;
        this.v2 = new BreakingBytesRefBuilder(breaker, label, v2.length);
        this.v2.copyBytes(v2);
    }

    long v1() {
        return this.v1;
    }

    void v1(long v1) {
        this.v1 = v1;
    }

    BytesRef v2() {
        return this.v2.bytesRefView();
    }

    void v2(BytesRef v2) {
        this.v2.copyBytes(v2);
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        blocks[offset + 0] = driverContext.blockFactory().newConstantLongBlockWith(this.v1, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantBytesRefBlockWith(this.v2.bytesRefView(), 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
    }

    public void close() {
        Releasables.close((Releasable)this.v2);
    }
}

