/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.elasticsearch.exponentialhistogram.Base2ExponentialHistogramIndexer;

public class ExponentialScaleUtils {
    private static final double LN_2 = Math.log(2.0);
    static final long[] SCALE_UP_CONSTANT_TABLE = new long[]{0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 288230376054894118L, 576448062320457790L, 1146436840887505800L, 2104167428150631728L, 3127054724296373505L, 3828045265094622256L, 4214097751025163417L, 4412149414858430624L, 4511824212543271281L, 4561743405547877994L, 4586713247558758689L, 4599199449917992829L, 4605442711287634239L, 4608564361996858084L, 4610125189854540715L, 4610905604096266504L, 4611295811256239977L, 4611490914841115537L, 4611588466634164420L, 4611637242530765249L, 4611661630479075212L, 4611673824453231387L, 4611679921440309624L, 4611682969933848761L, 4611684494180618332L, 4611685256304003118L, 4611685637365695511L, 4611685827896541707L, 4611685923161964805L, 4611685970794676354L, 4611685994611032129L, 4611686006519210016L, 4611686012473298960L, 4611686015450343432L, 4611686016938865668L, 4611686017683126786L, 4611686018055257345L, 4611686018241322624L, 4611686018334355264L, 4611686018380871584L, 4611686018404129744L, 4611686018415758824L, 4611686018421573364L, 4611686018424480634L};

    static long adjustScale(long index, int currentScale, int scaleAdjustment) {
        ExponentialScaleUtils.checkIndexAndScaleBounds(index, currentScale);
        int newScale = currentScale + scaleAdjustment;
        assert (newScale >= -11 && newScale <= 38) : "adjusted scale must be in the range [-11, 38]";
        if (scaleAdjustment <= 0) {
            return index >> -scaleAdjustment;
        }
        assert (scaleAdjustment <= 62) : "Scaling up more than 62 does not make sense";
        long offset = SCALE_UP_CONSTANT_TABLE[currentScale - -11] >> 63 - scaleAdjustment;
        return (index << scaleAdjustment) + offset;
    }

    public static int compareExponentiallyScaledValues(long idxA, int scaleA, long idxB, int scaleB) {
        if (scaleA > scaleB) {
            return -ExponentialScaleUtils.compareExponentiallyScaledValues(idxB, scaleB, idxA, scaleA);
        }
        int shifts = scaleB - scaleA;
        long scaledDownB = idxB >> shifts;
        int result = Long.compare(idxA, scaledDownB);
        if (result == 0) {
            assert (1L << shifts > 0L);
            long shiftedAway = idxB & (1L << shifts) - 1L;
            if (shiftedAway > 0L) {
                return -1;
            }
            return 0;
        }
        return result;
    }

    public static int getMaximumScaleIncrease(long index) {
        ExponentialScaleUtils.checkIndexBounds(index);
        index = Math.abs(index);
        return Long.numberOfLeadingZeros(index) - 2;
    }

    static int normalizeScale(long index, int scale) {
        return Math.max(-11, scale - Long.numberOfTrailingZeros(index));
    }

    public static double getUpperBucketBoundary(long index, int scale) {
        ExponentialScaleUtils.checkIndexAndScaleBounds(index, scale);
        return ExponentialScaleUtils.exponentiallyScaledToDoubleValue(index + 1L, scale);
    }

    public static double getLowerBucketBoundary(long index, int scale) {
        ExponentialScaleUtils.checkIndexAndScaleBounds(index, scale);
        return ExponentialScaleUtils.exponentiallyScaledToDoubleValue(index, scale);
    }

    static double exponentiallyScaledToDoubleValue(long index, int scale) {
        double inverseFactor = Math.scalb(LN_2, -scale);
        return Math.exp(inverseFactor * (double)index);
    }

    public static double getPointOfLeastRelativeError(long bucketIndex, int scale) {
        ExponentialScaleUtils.checkIndexAndScaleBounds(bucketIndex, scale);
        double histogramBase = Math.pow(2.0, Math.scalb(1.0f, -scale));
        if (Double.isFinite(histogramBase)) {
            double upperBound = ExponentialScaleUtils.getUpperBucketBoundary(bucketIndex, scale);
            return 2.0 / (histogramBase + 1.0) * upperBound;
        }
        if (bucketIndex >= 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    public static long computeIndex(double value, int scale) {
        ExponentialScaleUtils.checkScaleBounds(scale);
        return Base2ExponentialHistogramIndexer.computeIndex(value, scale);
    }

    private static void checkIndexAndScaleBounds(long index, int scale) {
        ExponentialScaleUtils.checkIndexBounds(index);
        ExponentialScaleUtils.checkScaleBounds(scale);
    }

    private static void checkScaleBounds(int scale) {
        assert (scale >= -11 && scale <= 38) : "scale must be in range [-11..38]";
    }

    private static void checkIndexBounds(long index) {
        assert (index >= -4611686018427387903L && index <= 0x3FFFFFFFFFFFFFFFL) : "index must be in range [-4611686018427387903..4611686018427387903]";
    }
}

