/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.annotate.JsonCreator;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.annotate.JsonProperty;

public class Field
implements Serializable {
    static final Field[] NO_FIELDS = new Field[0];
    private final String name;
    private final FieldType type;
    private final Field[] properties;

    public Field(String name, FieldType type) {
        this(name, type, NO_FIELDS);
    }

    public Field(String name, FieldType type, Collection<Field> properties) {
        this(name, type, properties != null ? properties.toArray(new Field[properties.size()]) : NO_FIELDS);
    }

    @JsonCreator
    Field(@JsonProperty(value="name") String name, @JsonProperty(value="type") FieldType type, @JsonProperty(value="properties") Field[] properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
    }

    @JsonProperty(value="properties")
    public Field[] properties() {
        return this.properties;
    }

    @JsonProperty(value="type")
    public FieldType type() {
        return this.type;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("%s=%s", this.name, this.type == FieldType.OBJECT || this.type == FieldType.NESTED ? Arrays.toString(this.properties) : this.type);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.deepEquals(this.properties, other.properties);
    }
}

