/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.logstash.health.HelpUrl;
import org.logstash.health.Impact;
import org.logstash.health.ImpactArea;
import org.logstash.health.Probe;
import org.logstash.health.ProbeIndicator;
import org.logstash.instrument.metrics.MetricKeys;

public class PipelineIndicator
extends ProbeIndicator<Details> {
    public static PipelineIndicator forPipeline(String pipelineId, PipelineDetailsProvider pipelineDetailsProvider) {
        PipelineIndicator pipelineIndicator = new PipelineIndicator(new DetailsSupplier(pipelineId, pipelineDetailsProvider));
        pipelineIndicator.attachProbe("status", new StatusProbe());
        pipelineIndicator.attachProbe("flow:worker_utilization", new FlowWorkerUtilizationProbe());
        return pipelineIndicator;
    }

    private PipelineIndicator(DetailsSupplier detailsSupplier) {
        super("pipeline", detailsSupplier::get);
    }

    public static class DetailsSupplier {
        private final String pipelineId;
        private final PipelineDetailsProvider pipelineDetailsProvider;

        DetailsSupplier(String pipelineId, PipelineDetailsProvider pipelineDetailsProvider) {
            this.pipelineId = pipelineId;
            this.pipelineDetailsProvider = pipelineDetailsProvider;
        }

        public Details get() {
            return this.pipelineDetailsProvider.pipelineDetails(this.pipelineId);
        }
    }

    @FunctionalInterface
    public static interface PipelineDetailsProvider {
        public Details pipelineDetails(String var1);
    }

    static class StatusProbe
    implements Probe<Details> {
        static final Impact.Builder NOT_PROCESSING = Impact.builder().withId(StatusProbe.impactId("not_processing")).withDescription("the pipeline is not currently processing").withAdditionalImpactArea(ImpactArea.PIPELINE_EXECUTION);
        static final HelpUrl HELP_URL = new HelpUrl("health-report-pipeline-status");

        StatusProbe() {
        }

        @Override
        public Probe.Analysis analyze(Details details) {
            switch (details.getStatus().getState()) {
                case LOADING: {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.YELLOW).withDiagnosis(db -> db.withId(StatusProbe.diagnosisId("loading")).withCause("pipeline is loading").withAction("if pipeline does not come up quickly, you may need to check the logs to see if it is stalled").withHelpUrl(HELP_URL.withAnchor("loading").toString())).withImpact(NOT_PROCESSING.withSeverity(1).withDescription("pipeline is loading").build()).build();
                }
                case RUNNING: {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.GREEN).build();
                }
                case FINISHED: {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.YELLOW).withDiagnosis(db -> db.withId(StatusProbe.diagnosisId("finished")).withCause("pipeline has finished running because its inputs have been closed and events have been processed").withAction("if you expect this pipeline to run indefinitely, you will need to configure its inputs to continue receiving or fetching events").withHelpUrl(HELP_URL.withAnchor("finished").toString())).withImpact(NOT_PROCESSING.withSeverity(10).withDescription("pipeline has finished running").build()).build();
                }
                case TERMINATED: {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.RED).withDiagnosis(db -> db.withId(StatusProbe.diagnosisId("terminated")).withCause("pipeline is not running, likely because it has encountered an error").withAction("view logs to determine the cause of abnormal pipeline shutdown").withHelpUrl(HELP_URL.withAnchor("terminated").toString())).withImpact(NOT_PROCESSING.withSeverity(1).build()).build();
                }
            }
            return Probe.Analysis.builder().withStatus(org.logstash.health.Status.UNKNOWN).withDiagnosis(db -> db.withId(StatusProbe.diagnosisId("unknown")).withCause("pipeline is not known; it may have been recently deleted or failed to start").withAction("view logs to determine if the pipeline failed to start").withHelpUrl(HELP_URL.withAnchor("unknown").toString())).withImpact(NOT_PROCESSING.withSeverity(2).build()).build();
        }

        static String diagnosisId(String state) {
            return String.format("logstash:health:pipeline:status:diagnosis:%s", state);
        }

        static String impactId(String state) {
            return String.format("logstash:health:pipeline:status:impact:%s", state);
        }
    }

    static class FlowWorkerUtilizationProbe
    implements Probe<Details> {
        static final String LAST_1_MINUTE = "last_1_minute";
        static final String LAST_5_MINUTES = "last_5_minutes";
        static final String WORKER_UTILIZATION = MetricKeys.WORKER_UTILIZATION_KEY.asJavaString();
        static final Impact.Builder BLOCKED_PROCESSING = Impact.builder().withId(FlowWorkerUtilizationProbe.impactId("blocked_processing")).withDescription("the pipeline is blocked").withAdditionalImpactArea(ImpactArea.PIPELINE_EXECUTION);
        static final HelpUrl HELP_URL = new HelpUrl("health-report-pipeline-flow-worker-utilization");

        FlowWorkerUtilizationProbe() {
        }

        @Override
        public Probe.Analysis analyze(Details observation) {
            OptionalDouble lastFiveMinutes = observation.flow.getRate(WORKER_UTILIZATION, LAST_5_MINUTES);
            OptionalDouble lastOneMinute = observation.flow.getRate(WORKER_UTILIZATION, LAST_1_MINUTE);
            if (lastFiveMinutes.isPresent()) {
                if (lastFiveMinutes.getAsDouble() > 99.999) {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.RED).withDiagnosis(db -> db.withId(FlowWorkerUtilizationProbe.diagnosisId("5m-blocked")).withCause(FlowWorkerUtilizationProbe.diagnosisCause("completely blocked", "five minutes", false)).withAction("address bottleneck or add resources").withHelpUrl(HELP_URL.withAnchor("blocked-5m").toString())).withImpact(BLOCKED_PROCESSING.withSeverity(1).build()).build();
                }
                if (lastFiveMinutes.getAsDouble() >= 95.0) {
                    boolean isRecovering = lastOneMinute.isPresent() && lastOneMinute.getAsDouble() <= 80.0;
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.YELLOW).withDiagnosis(db -> db.withId(FlowWorkerUtilizationProbe.diagnosisId("5m-nearly-blocked")).withCause(FlowWorkerUtilizationProbe.diagnosisCause("nearly blocked", "five minutes", isRecovering)).withAction(isRecovering ? "continue to monitor" : "address bottleneck or add resources").withHelpUrl(HELP_URL.withAnchor("nearly-blocked-5m").toString())).withImpact(BLOCKED_PROCESSING.withSeverity(1).build()).build();
                }
            }
            if (lastOneMinute.isPresent()) {
                if (lastOneMinute.getAsDouble() > 99.999) {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.YELLOW).withDiagnosis(db -> db.withId(FlowWorkerUtilizationProbe.diagnosisId("1m-blocked")).withCause(FlowWorkerUtilizationProbe.diagnosisCause("completely blocked", "one minute", false)).withAction("address bottleneck or add resources").withHelpUrl(HELP_URL.withAnchor("blocked-1m").toString())).withImpact(BLOCKED_PROCESSING.withSeverity(2).build()).build();
                }
                if (lastOneMinute.getAsDouble() >= 95.0) {
                    return Probe.Analysis.builder().withStatus(org.logstash.health.Status.YELLOW).withDiagnosis(db -> db.withId(FlowWorkerUtilizationProbe.diagnosisId("1m-nearly-blocked")).withCause(FlowWorkerUtilizationProbe.diagnosisCause("nearly blocked", "one minute", false)).withAction("address bottleneck or add resources").withHelpUrl(HELP_URL.withAnchor("nearly-blocked-1m").toString())).withImpact(BLOCKED_PROCESSING.withSeverity(2).build()).build();
                }
            }
            return Probe.Analysis.builder().build();
        }

        static String diagnosisCause(String condition, String period, boolean isRecovering) {
            StringBuilder cause = new StringBuilder("pipeline workers have been ").append(condition).append(" for at least ").append(period);
            if (isRecovering) {
                cause.append(", but they appear to be recovering");
            }
            return cause.toString();
        }

        static String diagnosisId(String state) {
            return String.format("logstash:health:pipeline:flow:worker_utilization:diagnosis:%s", state);
        }

        static String impactId(String state) {
            return String.format("logstash:health:pipeline:flow:impact:%s", state);
        }
    }

    @JsonSerialize(using=JsonSerializer.class)
    public static class FlowObservation {
        private static FlowObservation EMPTY = new FlowObservation(Map.of());
        final Map<String, Map<String, Double>> capture;

        public FlowObservation(Map<String, Map<String, Double>> capture) {
            this.capture = Objects.requireNonNull(capture, "capture cannot be null").entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Map.copyOf((Map)e.getValue())));
        }

        public OptionalDouble getRate(String flowMetricName, String flowMetricWindow) {
            Map<String, Double> flowMetrics = this.capture.get(flowMetricName);
            if (flowMetrics == null) {
                return OptionalDouble.empty();
            }
            Double rate = flowMetrics.get(flowMetricWindow);
            if (rate == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(rate);
        }

        public boolean isEmpty() {
            return this.capture.isEmpty() || this.capture.values().stream().allMatch(Map::isEmpty);
        }

        static class JsonSerializer
        extends com.fasterxml.jackson.databind.JsonSerializer<FlowObservation> {
            JsonSerializer() {
            }

            public void serialize(FlowObservation value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeObject(value.capture);
            }
        }
    }

    @JsonSerialize(using=JsonSerializer.class)
    public static class Details
    implements ProbeIndicator.Observation {
        private final Status status;
        private final FlowObservation flow;

        public Details(Status status, FlowObservation flow) {
            this.status = Objects.requireNonNull(status, "status cannot be null");
            this.flow = Objects.requireNonNullElse(flow, FlowObservation.EMPTY);
        }

        public Details(Status status) {
            this(status, null);
        }

        public Status getStatus() {
            return this.status;
        }

        public FlowObservation getFlow() {
            return this.flow;
        }

        public static class JsonSerializer
        extends com.fasterxml.jackson.databind.JsonSerializer<Details> {
            public void serialize(Details details, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("status", (Object)details.getStatus());
                FlowObservation flow = details.getFlow();
                if (flow != null && !flow.isEmpty()) {
                    jsonGenerator.writeObjectField("flow", (Object)flow);
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    @JsonSerialize(using=JsonSerializer.class)
    public static class Status {
        public static final Status UNKNOWN = new Status(State.UNKNOWN);
        public static final Status LOADING = new Status(State.LOADING);
        public static final Status RUNNING = new Status(State.RUNNING);
        public static final Status FINISHED = new Status(State.FINISHED);
        public static final Status TERMINATED = new Status(State.TERMINATED);
        private final State state;

        public Status(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public static enum State {
            UNKNOWN,
            LOADING,
            RUNNING,
            FINISHED,
            TERMINATED;

        }

        public static class JsonSerializer
        extends com.fasterxml.jackson.databind.JsonSerializer<Status> {
            public void serialize(Status value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                gen.writeStringField("state", value.getState().toString());
                gen.writeEndObject();
            }
        }
    }
}

