/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExecuteSnapshotLifecycleAction
extends ActionType<Response> {
    public static final ExecuteSnapshotLifecycleAction INSTANCE = new ExecuteSnapshotLifecycleAction();
    public static final String NAME = "cluster:admin/slm/execute";

    protected ExecuteSnapshotLifecycleAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final String snapshotName;

        public Response(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.snapshotName);
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("snapshot_name", this.getSnapshotName());
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String lifecycleId;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String lifecycleId) {
            super(masterNodeTimeout, ackTimeout);
            this.lifecycleId = lifecycleId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.lifecycleId = in.readString();
        }

        public String getLifecycleId() {
            return this.lifecycleId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.lifecycleId);
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return this.lifecycleId.equals(other.lifecycleId);
        }
    }
}

