/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.core.security.authc.support.BCrypt;

public enum Hasher {
    BCRYPT{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt();
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT4{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(4);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT5{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(5);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT6{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(6);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT7{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(7);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT8{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(8);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT9{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(9);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT10{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(10);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT11{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(11);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT12{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(12);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT13{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(13);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    BCRYPT14{

        @Override
        public char[] hash(SecureString text) {
            String salt = BCrypt.gensalt(14);
            return BCrypt.hashpw(text, salt).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return Hasher.verifyBcryptHash(text, hash);
        }
    }
    ,
    PBKDF2{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 10000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 10000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_1000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 1000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 1000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_10000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 10000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 10000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_50000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 50000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 50000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_100000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 100000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 100000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_500000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 500000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 500000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_1000000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(data, 1000000, Hasher.PBKDF2_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(data, hash, 1000000, Hasher.PBKDF2_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 10000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 10000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_1000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 1000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 1000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_10000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 10000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 10000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_50000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 50000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 50000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_100000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 100000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 100000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_500000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 500000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 500000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    PBKDF2_STRETCH_1000000{

        @Override
        public char[] hash(SecureString data) {
            return Hasher.getPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), 1000000, Hasher.PBKDF2_STRETCH_PREFIX);
        }

        @Override
        public boolean verify(SecureString data, char[] hash) {
            return Hasher.verifyPbkdf2Hash(new SecureString(Hasher.hashSha512(data)), hash, 1000000, Hasher.PBKDF2_STRETCH_PREFIX);
        }
    }
    ,
    SHA1{

        @Override
        public char[] hash(SecureString text) {
            byte[] textBytes = CharArrays.toUtf8Bytes(text.getChars());
            MessageDigest md = MessageDigests.sha1();
            md.update(textBytes);
            String hash = Base64.getEncoder().encodeToString(md.digest());
            return (Hasher.SHA1_PREFIX + hash).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            String hashStr = new String(hash);
            if (!hashStr.startsWith(Hasher.SHA1_PREFIX)) {
                return false;
            }
            byte[] textBytes = CharArrays.toUtf8Bytes(text.getChars());
            MessageDigest md = MessageDigests.sha1();
            md.update(textBytes);
            String passwd64 = Base64.getEncoder().encodeToString(md.digest());
            String hashNoPrefix = hashStr.substring(Hasher.SHA1_PREFIX.length());
            return CharArrays.constantTimeEquals(hashNoPrefix, passwd64);
        }
    }
    ,
    MD5{

        @Override
        public char[] hash(SecureString text) {
            MessageDigest md = MessageDigests.md5();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            String hash = Base64.getEncoder().encodeToString(md.digest());
            return (Hasher.MD5_PREFIX + hash).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            String hashStr = new String(hash);
            if (!hashStr.startsWith(Hasher.MD5_PREFIX)) {
                return false;
            }
            hashStr = hashStr.substring(Hasher.MD5_PREFIX.length());
            MessageDigest md = MessageDigests.md5();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            String computedHashStr = Base64.getEncoder().encodeToString(md.digest());
            return CharArrays.constantTimeEquals(hashStr, computedHashStr);
        }
    }
    ,
    SSHA256{

        @Override
        public char[] hash(SecureString text) {
            MessageDigest md = MessageDigests.sha256();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            byte[] salt = Hasher.generateSalt(8);
            md.update(salt);
            String hash = Base64.getEncoder().encodeToString(md.digest());
            char[] result = new char[Hasher.SSHA256_PREFIX.length() + 12 + hash.length()];
            System.arraycopy(Hasher.SSHA256_PREFIX.toCharArray(), 0, result, 0, Hasher.SSHA256_PREFIX.length());
            System.arraycopy(Base64.getEncoder().encodeToString(salt).toCharArray(), 0, result, Hasher.SSHA256_PREFIX.length(), 12);
            System.arraycopy(hash.toCharArray(), 0, result, Hasher.SSHA256_PREFIX.length() + 12, hash.length());
            return result;
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            String hashStr = new String(hash);
            if (!hashStr.startsWith(Hasher.SSHA256_PREFIX)) {
                return false;
            }
            hashStr = hashStr.substring(Hasher.SSHA256_PREFIX.length());
            char[] saltAndHash = hashStr.toCharArray();
            MessageDigest md = MessageDigests.sha256();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            md.update(Base64.getDecoder().decode(new String(saltAndHash, 0, 12)));
            String computedHash = Base64.getEncoder().encodeToString(md.digest());
            return CharArrays.constantTimeEquals(computedHash, new String(saltAndHash, 12, saltAndHash.length - 12));
        }
    }
    ,
    SHA256{

        @Override
        public char[] hash(SecureString text) {
            MessageDigest md = MessageDigests.sha256();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(md.digest()).toCharArray();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            MessageDigest md = MessageDigests.sha256();
            md.update(CharArrays.toUtf8Bytes(text.getChars()));
            return CharArrays.constantTimeEquals(Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(md.digest()).toCharArray(), hash);
        }
    }
    ,
    NOOP{

        @Override
        public char[] hash(SecureString text) {
            return text.clone().getChars();
        }

        @Override
        public boolean verify(SecureString text, char[] hash) {
            return CharArrays.constantTimeEquals(text.getChars(), hash);
        }
    };

    private static final int BCRYPT_PREFIX_LENGTH = 4;
    private static final String SHA1_PREFIX = "{SHA}";
    private static final String MD5_PREFIX = "{MD5}";
    private static final String SSHA256_PREFIX = "{SSHA256}";
    private static final String PBKDF2_PREFIX = "{PBKDF2}";
    private static final String PBKDF2_STRETCH_PREFIX = "{PBKDF2_STRETCH}";
    private static final int PBKDF2_DEFAULT_COST = 10000;
    private static final int PBKDF2_KEY_LENGTH = 256;
    private static final int BCRYPT_DEFAULT_COST = 10;
    private static final SecureRandom SECURE_RANDOM;
    private static final int HMAC_SHA512_BLOCK_SIZE_IN_BITS = 128;
    private static final int PBKDF2_MIN_SALT_LENGTH_IN_BYTES = 8;

    public static Hasher resolve(String name) {
        return switch (name.toLowerCase(Locale.ROOT)) {
            case "bcrypt" -> BCRYPT;
            case "bcrypt4" -> BCRYPT4;
            case "bcrypt5" -> BCRYPT5;
            case "bcrypt6" -> BCRYPT6;
            case "bcrypt7" -> BCRYPT7;
            case "bcrypt8" -> BCRYPT8;
            case "bcrypt9" -> BCRYPT9;
            case "bcrypt10" -> BCRYPT;
            case "bcrypt11" -> BCRYPT11;
            case "bcrypt12" -> BCRYPT12;
            case "bcrypt13" -> BCRYPT13;
            case "bcrypt14" -> BCRYPT14;
            case "pbkdf2" -> PBKDF2;
            case "pbkdf2_1000" -> PBKDF2_1000;
            case "pbkdf2_10000" -> PBKDF2;
            case "pbkdf2_50000" -> PBKDF2_50000;
            case "pbkdf2_100000" -> PBKDF2_100000;
            case "pbkdf2_500000" -> PBKDF2_500000;
            case "pbkdf2_1000000" -> PBKDF2_1000000;
            case "pbkdf2_stretch" -> PBKDF2_STRETCH;
            case "pbkdf2_stretch_1000" -> PBKDF2_STRETCH_1000;
            case "pbkdf2_stretch_10000" -> PBKDF2_STRETCH_10000;
            case "pbkdf2_stretch_50000" -> PBKDF2_STRETCH_50000;
            case "pbkdf2_stretch_100000" -> PBKDF2_STRETCH_100000;
            case "pbkdf2_stretch_500000" -> PBKDF2_STRETCH_500000;
            case "pbkdf2_stretch_1000000" -> PBKDF2_STRETCH_1000000;
            case "sha1" -> SHA1;
            case "md5" -> MD5;
            case "ssha256" -> SSHA256;
            case "noop", "clear_text" -> NOOP;
            default -> throw new IllegalArgumentException("unknown hash function [" + name + "]");
        };
    }

    public static Hasher resolveFromHash(char[] hash) {
        if (Hasher.isBcryptPrefix(hash)) {
            int cost = Integer.parseInt(new String(Arrays.copyOfRange(hash, 4, hash.length - 54)));
            return cost == 10 ? BCRYPT : Hasher.resolve("bcrypt" + cost);
        }
        if (CharArrays.charsBeginsWith(PBKDF2_STRETCH_PREFIX, hash)) {
            int cost = Hasher.parsePbkdf2Iterations(hash, PBKDF2_STRETCH_PREFIX);
            return cost == 10000 ? PBKDF2_STRETCH : Hasher.resolve("pbkdf2_stretch_" + cost);
        }
        if (CharArrays.charsBeginsWith(PBKDF2_PREFIX, hash)) {
            int cost = Hasher.parsePbkdf2Iterations(hash, PBKDF2_PREFIX);
            return cost == 10000 ? PBKDF2 : Hasher.resolve("pbkdf2_" + cost);
        }
        if (CharArrays.charsBeginsWith(SHA1_PREFIX, hash)) {
            return SHA1;
        }
        if (CharArrays.charsBeginsWith(MD5_PREFIX, hash)) {
            return MD5;
        }
        if (CharArrays.charsBeginsWith(SSHA256_PREFIX, hash)) {
            return SSHA256;
        }
        return NOOP;
    }

    private static boolean isBcryptPrefix(char[] hash) {
        if (hash.length < 4) {
            return false;
        }
        if (hash[0] == '$' && hash[1] == '2' && hash[3] == '$') {
            return BCrypt.valid_minor(hash[2]);
        }
        return false;
    }

    public static boolean verifyHash(SecureString data, char[] hash) {
        Hasher hasher = Hasher.resolveFromHash(hash);
        return hasher.verify(data, hash);
    }

    private static char[] getPbkdf2Hash(SecureString data, int cost, String prefix) {
        try {
            CharBuffer result = CharBuffer.allocate(prefix.length() + String.valueOf(cost).length() + 2 + 44 + 44);
            result.put(prefix);
            result.put(String.valueOf(cost));
            result.put("$");
            byte[] salt = Hasher.generateSalt(32);
            result.put(Base64.getEncoder().encodeToString(salt));
            result.put("$");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
            PBEKeySpec keySpec = new PBEKeySpec(data.getChars(), salt, cost, 256);
            result.put(Base64.getEncoder().encodeToString(secretKeyFactory.generateSecret(keySpec).getEncoded()));
            return result.array();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new ElasticsearchException("Error using PBKDF2 for password hashing", (Throwable)e, new Object[0]);
        }
        catch (Error e) {
            throw new ElasticsearchException("Error using PBKDF2 implementation from the selected Security Provider", (Throwable)e, new Object[0]);
        }
    }

    private static int parsePbkdf2Iterations(char[] hash, String prefix) {
        int separator = -1;
        for (int i = prefix.length(); i < hash.length; ++i) {
            if (hash[i] != '$') continue;
            separator = i;
            break;
        }
        if (separator == -1) {
            throw new IllegalArgumentException("The number of iterations could not be determined from the provided PBKDF2 hash.");
        }
        try {
            return Integer.parseInt(new String(hash, prefix.length(), separator - prefix.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The number of iterations could not be determined from the provided PBKDF2 hash.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyPbkdf2Hash(SecureString data, char[] hash, int iterations, String prefix) {
        boolean bl;
        char[] saltChars;
        block10: {
            int i;
            if (!CharArrays.charsBeginsWith(prefix, hash)) {
                return false;
            }
            int separator1 = -1;
            int separator2 = -1;
            for (i = prefix.length() + String.valueOf(iterations).length(); i < hash.length; ++i) {
                if (hash[i] != '$') continue;
                separator1 = i;
                break;
            }
            if (separator1 == -1) {
                return false;
            }
            for (i = separator1 + 1; i < hash.length; ++i) {
                if (hash[i] != '$') continue;
                separator2 = i;
                break;
            }
            if (separator2 == -1) {
                return false;
            }
            char[] hashChars = null;
            saltChars = null;
            try {
                hashChars = Arrays.copyOfRange(hash, separator2 + 1, hash.length);
                saltChars = Arrays.copyOfRange(hash, separator1 + 1, separator2);
                int keySize = hashChars.length * 3 / 64 * 128;
                bl = Hasher.verifyPbkdf2Hash(data, iterations, keySize, saltChars, hashChars);
                if (null == hashChars) break block10;
            }
            catch (Throwable throwable) {
                if (null != hashChars) {
                    Arrays.fill(hashChars, '\u0000');
                }
                if (null != saltChars) {
                    Arrays.fill(saltChars, '\u0000');
                }
                throw throwable;
            }
            Arrays.fill(hashChars, '\u0000');
        }
        if (null != saltChars) {
            Arrays.fill(saltChars, '\u0000');
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyPbkdf2Hash(SecureString data, int iterations, int keyLength, char[] saltChars, char[] hashChars) {
        boolean bl;
        block8: {
            if (keyLength <= 0 || keyLength % 128 != 0) {
                throw new ElasticsearchException("PBKDF2 key length must be positive and multiple of [128 bits]", new Object[0]);
            }
            byte[] saltBytes = Base64.getDecoder().decode(CharArrays.toUtf8Bytes(saltChars));
            if (saltBytes.length < 8) {
                throw new ElasticsearchException("PBKDF2 salt must be at least [8 bytes] long", new Object[0]);
            }
            char[] computedPwdHash = null;
            try {
                boolean result;
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
                PBEKeySpec keySpec = new PBEKeySpec(data.getChars(), saltBytes, iterations, keyLength);
                computedPwdHash = CharArrays.utf8BytesToChars(Base64.getEncoder().encode(secretKeyFactory.generateSecret(keySpec).getEncoded()));
                bl = result = CharArrays.constantTimeEquals(computedPwdHash, hashChars);
                if (null == computedPwdHash) break block8;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                try {
                    throw new ElasticsearchException("Error using PBKDF2 for password hashing", (Throwable)e, new Object[0]);
                    catch (Error e2) {
                        throw new ElasticsearchException("Error using PBKDF2 implementation from the selected Security Provider", (Throwable)e2, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (null != computedPwdHash) {
                        Arrays.fill(computedPwdHash, '\u0000');
                    }
                    throw throwable;
                }
            }
            Arrays.fill(computedPwdHash, '\u0000');
        }
        return bl;
    }

    private static boolean verifyBcryptHash(SecureString text, char[] hash) {
        String hashStr = new String(hash);
        if (!Hasher.isBcryptPrefix(hash)) {
            return false;
        }
        return BCrypt.checkpw(text, hashStr);
    }

    @SuppressForbidden(reason="This is the only allowed way to get available values")
    public static List<String> getAvailableAlgoStoredPasswordHash() {
        return Arrays.stream(Hasher.values()).map(Enum::name).map(name -> name.toLowerCase(Locale.ROOT)).filter(name -> name.startsWith("pbkdf2") || name.startsWith("bcrypt")).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="This is the only allowed way to get available values")
    public static List<String> getAvailableAlgoStoredSecureTokenHash() {
        return Arrays.stream(Hasher.values()).map(Enum::name).map(name -> name.toLowerCase(Locale.ROOT)).filter(name -> name.startsWith("pbkdf2") || name.startsWith("bcrypt") || name.equals("ssha256")).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="This is the only allowed way to get available values")
    public static List<String> getAvailableAlgoCacheHash() {
        return Arrays.stream(Hasher.values()).map(Enum::name).map(name -> name.toLowerCase(Locale.ROOT)).filter(name -> !name.equals("sha256")).collect(Collectors.toList());
    }

    public abstract char[] hash(SecureString var1);

    public abstract boolean verify(SecureString var1, char[] var2);

    private static byte[] generateSalt(int length) {
        byte[] salt = new byte[length];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    private static char[] hashSha512(SecureString text) {
        MessageDigest md = MessageDigests.sha512();
        md.update(CharArrays.toUtf8Bytes(text.getChars()));
        return MessageDigests.toHexCharArray(md.digest());
    }

    static {
        SECURE_RANDOM = new SecureRandom();
    }
}

