/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.usage;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.usage.SemanticTextStats;

public class ModelStats
implements ToXContentObject,
Writeable {
    public static final NodeFeature SEMANTIC_TEXT_USAGE = new NodeFeature("inference.semantic_text_usage");
    static final TransportVersion INFERENCE_TELEMETRY_ADDED_SEMANTIC_TEXT_STATS = TransportVersion.fromName("inference_telemetry_added_semantic_text_stats");
    private final String service;
    private final TaskType taskType;
    private long count;
    @Nullable
    private final SemanticTextStats semanticTextStats;

    public ModelStats(String service, TaskType taskType, long count, @Nullable SemanticTextStats semanticTextStats) {
        this.service = service;
        this.taskType = taskType;
        this.count = count;
        this.semanticTextStats = semanticTextStats;
    }

    public ModelStats(StreamInput in) throws IOException {
        this.service = in.readString();
        this.taskType = in.readEnum(TaskType.class);
        this.count = in.readLong();
        this.semanticTextStats = in.getTransportVersion().supports(INFERENCE_TELEMETRY_ADDED_SEMANTIC_TEXT_STATS) ? in.readOptional(SemanticTextStats::new) : null;
    }

    public void add() {
        ++this.count;
    }

    public String service() {
        return this.service;
    }

    public TaskType taskType() {
        return this.taskType;
    }

    public long count() {
        return this.count;
    }

    @Nullable
    public SemanticTextStats semanticTextStats() {
        return this.semanticTextStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public void addXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("service", this.service);
        builder.field("task_type", this.taskType.name());
        builder.field("count", this.count);
        if (this.semanticTextStats != null) {
            builder.field("semantic_text", this.semanticTextStats);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.service);
        out.writeEnum(this.taskType);
        out.writeLong(this.count);
        if (out.getTransportVersion().supports(INFERENCE_TELEMETRY_ADDED_SEMANTIC_TEXT_STATS)) {
            out.writeOptionalWriteable(this.semanticTextStats);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelStats that = (ModelStats)o;
        return this.count == that.count && Objects.equals(this.service, that.service) && this.taskType == that.taskType && Objects.equals(this.semanticTextStats, that.semanticTextStats);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.taskType, this.count, this.semanticTextStats);
    }
}

