/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logstashbridge.threadpool;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logstashbridge.StableBridgeAPI;
import org.elasticsearch.logstashbridge.common.SettingsBridge;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.DefaultBuiltInExecutorBuilders;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public interface ThreadPoolBridge
extends StableBridgeAPI<ThreadPool> {
    public long relativeTimeInMillis();

    public long absoluteTimeInMillis();

    public boolean terminate(long var1, TimeUnit var3);

    public static ThreadPoolBridge create(SettingsBridge bridgedSettings) {
        ThreadPool internal = new ThreadPool((Settings)bridgedSettings.toInternal(), MeterRegistry.NOOP, new DefaultBuiltInExecutorBuilders(), new ExecutorBuilder[0]);
        return new ProxyInternal(internal);
    }

    public static class ProxyInternal
    extends StableBridgeAPI.ProxyInternal<ThreadPool>
    implements ThreadPoolBridge {
        ProxyInternal(ThreadPool delegate) {
            super(delegate);
        }

        @Override
        public long relativeTimeInMillis() {
            return ((ThreadPool)this.internalDelegate).relativeTimeInMillis();
        }

        @Override
        public long absoluteTimeInMillis() {
            return ((ThreadPool)this.internalDelegate).absoluteTimeInMillis();
        }

        @Override
        public boolean terminate(long timeout, TimeUnit timeUnit) {
            return ThreadPool.terminate((ThreadPool)this.internalDelegate, timeout, timeUnit);
        }
    }
}

