/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IdsQueryBuilder
extends AbstractQueryBuilder<IdsQueryBuilder> {
    public static final String NAME = "ids";
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private final Set<String> ids = new HashSet<String>();
    private static final ObjectParser<IdsQueryBuilder, Void> PARSER = new ObjectParser("ids", IdsQueryBuilder::new);

    public IdsQueryBuilder() {
    }

    public IdsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in ids query but found [" + Arrays.toString(types) + "]");
        }
        Collections.addAll(this.ids, in.readStringArray());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeStringCollection(this.ids);
    }

    public IdsQueryBuilder addIds(String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("[ids] ids cannot be null");
        }
        Collections.addAll(this.ids, ids);
        return this;
    }

    public Set<String> ids() {
        return this.ids;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(VALUES_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static IdsQueryBuilder fromXContent(XContentParser parser) {
        try {
            return PARSER.apply(parser, null);
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), e, new Object[0]);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.ids.isEmpty()) {
            return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query was rewritten to a \"match_none\" query.");
        }
        SearchExecutionContext context = queryRewriteContext.convertToSearchExecutionContext();
        if (context != null && !context.hasMappings()) {
            return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query was rewritten to a \"match_none\" query.");
        }
        return super.doRewrite(queryRewriteContext);
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        MappedFieldType idField = context.getFieldType("_id");
        if (idField == null || this.ids.isEmpty()) {
            throw new IllegalStateException("Rewrite first");
        }
        return idField.termsQuery(new ArrayList<String>(this.ids), context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids);
    }

    @Override
    protected boolean doEquals(IdsQueryBuilder other) {
        return Objects.equals(this.ids, other.ids);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::addIds), VALUES_FIELD);
        IdsQueryBuilder.declareStandardFields(PARSER);
    }
}

