/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xcontent.XContentParser;

class FlattenedFieldParser {
    static final String SEPARATOR = "\u0000";
    private static final byte SEPARATOR_BYTE = 0;
    private final String rootFieldFullPath;
    private final String keyedFieldFullPath;
    private final String keyedIgnoredValuesFieldFullPath;
    private final MappedFieldType fieldType;
    private final int depthLimit;
    private final int ignoreAbove;
    private final String nullValue;

    FlattenedFieldParser(String rootFieldFullPath, String keyedFieldFullPath, String keyedIgnoredValuesFieldFullPath, MappedFieldType fieldType, int depthLimit, int ignoreAbove, String nullValue) {
        this.rootFieldFullPath = rootFieldFullPath;
        this.keyedFieldFullPath = keyedFieldFullPath;
        this.keyedIgnoredValuesFieldFullPath = keyedIgnoredValuesFieldFullPath;
        this.fieldType = fieldType;
        this.depthLimit = depthLimit;
        this.ignoreAbove = ignoreAbove;
        this.nullValue = nullValue;
    }

    public List<IndexableField> parse(DocumentParserContext documentParserContext) throws IOException {
        XContentParser parser = documentParserContext.parser();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        ContentPath path = new ContentPath();
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        Context context = new Context(parser, documentParserContext);
        this.parseObject(context, path, fields);
        return fields;
    }

    private void parseObject(Context context, ContentPath path, List<IndexableField> fields) throws IOException {
        String currentName = null;
        XContentParser parser = context.parser();
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            assert (currentName != null);
            this.parseFieldValue(context, token, path, currentName, fields);
        }
        return;
    }

    private void parseArray(Context context, ContentPath path, String currentName, List<IndexableField> fields) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            this.parseFieldValue(context, token, path, currentName, fields);
        }
        return;
    }

    private void parseFieldValue(Context context, XContentParser.Token token, ContentPath path, String currentName, List<IndexableField> fields) throws IOException {
        XContentParser parser = context.parser();
        if (token == XContentParser.Token.START_OBJECT) {
            path.add(currentName);
            this.validateDepthLimit(path);
            this.parseObject(context, path, fields);
            path.remove();
        } else if (token == XContentParser.Token.START_ARRAY) {
            this.parseArray(context, path, currentName, fields);
        } else if (token.isValue()) {
            String value = parser.text();
            this.addField(context, path, currentName, value, fields);
        } else if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                this.addField(context, path, currentName, this.nullValue, fields);
            }
        } else {
            throw new IllegalArgumentException("Encountered unexpected token [" + token.toString() + "].");
        }
    }

    private void addField(Context context, ContentPath path, String currentName, String value, List<IndexableField> fields) {
        String key = path.pathAsText(currentName);
        if (key.contains(SEPARATOR)) {
            throw new IllegalArgumentException("Keys in [flattened] fields cannot contain the reserved character \\0. Offending key: [" + key + "].");
        }
        String keyedValue = FlattenedFieldParser.createKeyedValue(key, value);
        BytesRef bytesKeyedValue = new BytesRef(keyedValue);
        if (value.length() > this.ignoreAbove) {
            if (context.documentParserContext().mappingLookup().isSourceSynthetic()) {
                fields.add(new StoredField(this.keyedIgnoredValuesFieldFullPath, bytesKeyedValue));
            }
            return;
        }
        if (bytesKeyedValue.length > 32766) {
            String msg = "Flattened field [" + this.rootFieldFullPath + "] contains one immense field whose keyed encoding is longer than the allowed max length of 32766 bytes. Key length: " + key.length() + ", value length: " + value.length() + " for key starting with [" + key.substring(0, Math.min(key.length(), 50)) + "]";
            throw new IllegalArgumentException(msg);
        }
        BytesRef bytesValue = new BytesRef(value);
        if (this.fieldType.isIndexed()) {
            fields.add(new StringField(this.rootFieldFullPath, bytesValue, Field.Store.NO));
            fields.add(new StringField(this.keyedFieldFullPath, bytesKeyedValue, Field.Store.NO));
        }
        if (this.fieldType.hasDocValues()) {
            fields.add(new SortedSetDocValuesField(this.rootFieldFullPath, bytesValue));
            fields.add(new SortedSetDocValuesField(this.keyedFieldFullPath, bytesKeyedValue));
            if (!this.fieldType.isDimension() || context.documentParserContext().getRoutingFields().isNoop()) {
                return;
            }
            String keyedFieldName = FlattenedFieldParser.extractKey(bytesKeyedValue).utf8ToString();
            if (this.fieldType.isDimension() && this.fieldType.dimensions().contains(keyedFieldName)) {
                BytesRef keyedFieldValue = FlattenedFieldParser.extractValue(bytesKeyedValue);
                context.documentParserContext().getRoutingFields().addString(this.rootFieldFullPath + "." + keyedFieldName, keyedFieldValue);
            }
        }
    }

    private void validateDepthLimit(ContentPath path) {
        if (path.length() + 1 > this.depthLimit) {
            throw new IllegalArgumentException("The provided [flattened] field [" + this.rootFieldFullPath + "] exceeds the maximum depth limit of [" + this.depthLimit + "].");
        }
    }

    static String createKeyedValue(String key, String value) {
        return key + SEPARATOR + value;
    }

    static BytesRef extractKey(BytesRef keyedValue) {
        int length;
        for (length = 0; length < keyedValue.length && keyedValue.bytes[keyedValue.offset + length] != 0; ++length) {
        }
        return new BytesRef(keyedValue.bytes, keyedValue.offset, length);
    }

    static BytesRef extractValue(BytesRef keyedValue) {
        int length;
        for (length = 0; length < keyedValue.length && keyedValue.bytes[keyedValue.offset + length] != 0; ++length) {
        }
        int valueStart = keyedValue.offset + length + 1;
        return new BytesRef(keyedValue.bytes, valueStart, keyedValue.length - valueStart);
    }

    private record Context(XContentParser parser, DocumentParserContext documentParserContext) {
    }
}

