"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HideTabsBar = void 0;
var _react = require("react");
var _redux = require("../../state_management/redux");
var _types = require("../../state_management/redux/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HideTabsBar = ({
  children
}) => {
  const dispatch = (0, _redux.useInternalStateDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_redux.internalStateActions.setTabsBarVisibility(_types.TabsBarVisibility.hidden));
    return () => {
      dispatch(_redux.internalStateActions.setTabsBarVisibility(_types.TabsBarVisibility.default));
    };
  }, [dispatch]);
  return children;
};
exports.HideTabsBar = HideTabsBar;