"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../shared_imports");
var _field_editor_context = require("../../field_editor_context");
var _field_format_editor = require("../../field_format_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor/form_fields/format_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormatField = ({
  disabled
}) => {
  const {
    uiSettings,
    fieldFormats,
    fieldFormatEditors
  } = (0, _field_editor_context.useFieldEditorContext)();
  const isMounted = (0, _react.useRef)(false);
  const [{
    type
  }] = (0, _shared_imports.useFormData)({
    watch: ['name', 'type']
  });
  const {
    getFields,
    isSubmitted
  } = (0, _shared_imports.useFormContext)();
  const [formatError, setFormatError] = (0, _react.useState)();
  // convert from combobox type to values
  const typeValue = type.reduce((collector, item) => {
    if (item.value !== undefined) {
      collector.push(item.value);
    }
    return collector;
  }, []);
  (0, _react.useEffect)(() => {
    if (formatError === undefined) {
      getFields().format.setErrors([]);
    } else {
      getFields().format.setErrors([{
        message: formatError
      }]);
    }
  }, [formatError, getFields]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      getFields().format.reset();
    }
    isMounted.current = true;
  }, [type, getFields]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "format",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, ({
    setValue,
    errors,
    value
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSubmitted && errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: errors.map(err => err.message),
      color: "danger",
      iconType: "cross",
      "data-test-subj": "formFormatError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_field_format_editor.FormatSelectEditor, {
      esTypes: typeValue || ['keyword'],
      fieldFormatEditors: fieldFormatEditors,
      fieldFormats: fieldFormats,
      uiSettings: uiSettings,
      onChange: setValue,
      onError: setFormatError,
      value: value,
      key: typeValue.join(', '),
      disabled: disabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }));
  });
};
exports.FormatField = FormatField;