"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PER_PAGE_STORAGE_KEY = exports.IndicesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/data-views-plugin/public");
var _rollup = require("@kbn/rollup");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/preview_panel/indices_list/indices_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const PER_PAGE_INCREMENTS = [5, 10, 20, 50];
const PER_PAGE_STORAGE_KEY = exports.PER_PAGE_STORAGE_KEY = 'dataViews.previewPanel.indicesPerPage';
class IndicesList extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "pager", void 0);
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "resetPageTo0", () => this.onChangePage(0));
    (0, _defineProperty2.default)(this, "onChangePage", page => {
      this.pager.goToPageIndex(page);
      this.setState({
        page
      });
    });
    (0, _defineProperty2.default)(this, "onChangePerPage", perPage => {
      this.pager.setItemsPerPage(perPage);
      this.setState({
        perPage
      });
      this.resetPageTo0();
      this.closePerPageControl();
      this.storage.set(PER_PAGE_STORAGE_KEY, perPage);
    });
    (0, _defineProperty2.default)(this, "openPerPageControl", () => {
      this.setState({
        isPerPageControlOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closePerPageControl", () => {
      this.setState({
        isPerPageControlOpen: false
      });
    });
    this.storage = new _public.Storage(localStorage);
    this.state = {
      page: 0,
      perPage: this.storage.get(PER_PAGE_STORAGE_KEY) || PER_PAGE_INCREMENTS[1],
      isPerPageControlOpen: false
    };
    this.pager = new _eui.Pager(props.indices.length, this.state.perPage, this.state.page);
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.indices.length !== this.props.indices.length) {
      this.pager.setTotalItems(nextProps.indices.length);
      this.resetPageTo0();
    }
  }
  renderPagination() {
    const {
      perPage,
      page,
      isPerPageControlOpen
    } = this.state;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.openPerPageControl,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.pagingLabel",
      defaultMessage: "Rows per page: {perPage}",
      values: {
        perPage
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }));
    const items = PER_PAGE_INCREMENTS.map(increment => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: increment,
        icon: "empty",
        onClick: () => this.onChangePerPage(increment),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      }, increment);
    });
    const pageCount = this.pager.getTotalPages();
    const paginationControls = pageCount > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      pageCount: pageCount,
      activePage: page,
      onPageClick: this.onChangePage,
      "aria-label": _i18n.i18n.translate('indexPatternEditor.pagination.ariaLabel', {
        defaultMessage: 'Indices list pagination'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "customizablePagination",
      button: button,
      isOpen: isPerPageControlOpen,
      closePopover: this.closePerPageControl,
      panelPaddingSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    }))), paginationControls);
  }
  highlightIndexName(indexName, query) {
    const {
      isExactMatch
    } = this.props;
    if (!query) {
      return indexName;
    }
    if (isExactMatch(indexName)) {
      return /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 14
        }
      }, indexName);
    }
    const queryAsArray = query.split(',').map(q => q.trim()).filter(Boolean);
    let queryIdx = -1;
    let queryWithoutWildcard = '';
    for (let i = 0; i < queryAsArray.length; i++) {
      const queryComponent = queryAsArray[i];
      queryWithoutWildcard = queryComponent.endsWith('*') ? queryComponent.substring(0, queryComponent.length - 1) : queryComponent;
      queryIdx = indexName.indexOf(queryWithoutWildcard);
      if (queryIdx !== -1) {
        break;
      }
    }
    if (queryIdx === -1) {
      return indexName;
    }
    const preStr = indexName.substring(0, queryIdx);
    const postStr = indexName.substr(queryIdx + queryWithoutWildcard.length);
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 7
      }
    }, preStr, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }, queryWithoutWildcard), postStr);
  }
  render() {
    const {
      indices,
      query,
      isExactMatch,
      ...rest
    } = this.props;
    const paginatedIndices = indices.slice(this.pager.firstItemIndex, this.pager.lastItemIndex + 1);
    const rows = paginatedIndices.map((index, key) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 11
        }
      }, this.highlightIndexName(index.name, query)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 11
        }
      }, index.tags.map(tag => {
        const badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          key: `index_${key}_tag_${tag.key}`,
          color: tag.color,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 17
          }
        }, tag.name);
        return tag.key === _public2.INDEX_PATTERN_TYPE.ROLLUP ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 25
          }
        }, badge)) : badge;
      })));
    });
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
      responsiveBreakpoint: false,
      tableLayout: "auto",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, rows)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 9
      }
    }), this.renderPagination());
  }
}
exports.IndicesList = IndicesList;