"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.leaderIndexValidator = exports.indexNameValidator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/services/input_validation.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isEmpty = value => {
  return !value || !value.trim().length;
};
const hasSpaces = value => typeof value === 'string' ? value.includes(' ') : false;
const beginsWithPeriod = value => {
  return value[0] === '.';
};
const findIllegalCharacters = value => {
  return _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.reduce((chars, char) => {
    if (value.includes(char)) {
      chars.push(char);
    }
    return chars;
  }, []);
};
const indexNameValidator = value => {
  if (isEmpty(value)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.errors.nameMissingMessage",
      defaultMessage: "Name is required.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    })];
  }
  if (beginsWithPeriod(value)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.errors.nameBeginsWithPeriodMessage",
      defaultMessage: "Name can't begin with a period.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    })];
  }
  const illegalCharacters = findIllegalCharacters(value);
  if (illegalCharacters.length) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.errors.nameIllegalCharactersMessage",
      defaultMessage: "Remove the characters {characterList} from your name.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 34
          }
        }, illegalCharacters.join(' '))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    })];
  }
  if (hasSpaces(value)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.indexNameValidation.noEmptySpace",
      defaultMessage: "Spaces are not allowed in the name.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    })];
  }
  return undefined;
};
exports.indexNameValidator = indexNameValidator;
const leaderIndexValidator = value => {
  if (isEmpty(value)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.errors.leaderIndexMissingMessage",
      defaultMessage: "Leader index is required.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    })];
  }
  const illegalCharacters = findIllegalCharacters(value);
  if (illegalCharacters.length) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.errors.leaderIndexIllegalCharactersMessage",
      defaultMessage: "Remove the characters {characterList} from your leader index.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 34
          }
        }, illegalCharacters.join(' '))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    })];
  }
  if (hasSpaces(value)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.leaderIndexValidation.noEmptySpace",
      defaultMessage: "Spaces are not allowed in the leader index.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    })];
  }
  return undefined;
};
exports.leaderIndexValidator = leaderIndexValidator;