"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRangesliderControlFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _controlsConstants = require("@kbn/controls-constants");
var _is_compressed = require("../../../control_group/utils/is_compressed");
var _data_control_manager = require("../data_control_manager");
var _range_slider_control = require("./components/range_slider_control");
var _has_no_results = require("./has_no_results");
var _min_max = require("./min_max");
var _range_control_selections = require("./range_control_selections");
var _range_slider_strings = require("./range_slider_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/range_slider/get_range_slider_control_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRangesliderControlFactory = () => {
  return {
    type: _controlsConstants.RANGE_SLIDER_CONTROL,
    getIconType: () => 'controlsHorizontal',
    getDisplayName: _range_slider_strings.RangeSliderStrings.control.getDisplayName,
    isFieldCompatible: field => {
      return field.aggregatable && field.type === 'number';
    },
    CustomOptionsComponent: ({
      initialState,
      updateState,
      setControlEditorValid
    }) => {
      var _initialState$step;
      const [step, setStep] = (0, _react.useState)((_initialState$step = initialState.step) !== null && _initialState$step !== void 0 ? _initialState$step : 1);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: _range_slider_strings.RangeSliderStrings.editor.getStepTitle(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        compressed: true,
        value: step,
        onChange: event => {
          const newStep = event.target.valueAsNumber;
          setStep(newStep);
          updateState({
            step: newStep
          });
          setControlEditorValid(newStep > 0);
        },
        min: 0,
        isInvalid: step === undefined || step <= 0,
        "data-test-subj": "rangeSliderControl__stepAdditionalSetting",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 13
        }
      })));
    },
    buildControl: async ({
      initialState,
      finalizeApi,
      uuid,
      controlGroupApi
    }) => {
      var _initialState$step2;
      const controlFetch$ = controlGroupApi.controlFetch$(uuid);
      const loadingMinMax$ = new _rxjs.BehaviorSubject(false);
      const loadingHasNoResults$ = new _rxjs.BehaviorSubject(false);
      const dataLoading$ = new _rxjs.BehaviorSubject(undefined);
      const step$ = new _rxjs.BehaviorSubject((_initialState$step2 = initialState.step) !== null && _initialState$step2 !== void 0 ? _initialState$step2 : 1);
      const dataControlManager = (0, _data_control_manager.initializeDataControlManager)(uuid, _controlsConstants.RANGE_SLIDER_CONTROL, initialState, () => ({
        step: step$.getValue()
      }), editorState => {
        if (editorState.step !== step$.getValue()) step$.next(editorState.step);
      }, controlGroupApi);
      const selections = (0, _range_control_selections.initializeRangeControlSelections)(initialState, dataControlManager.internalApi.onSelectionChange);
      function serializeState() {
        return {
          rawState: {
            ...dataControlManager.getLatestState(),
            step: step$.getValue(),
            value: selections.value$.getValue()
          },
          references: dataControlManager.internalApi.extractReferences('rangeSliderDataView')
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi: controlGroupApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(dataControlManager.anyStateChange$, selections.value$, step$).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => {
          return {
            ..._data_control_manager.defaultDataControlComparators,
            value: 'referenceEquality',
            step: (a, b) => (a !== null && a !== void 0 ? a : 1) === (b !== null && b !== void 0 ? b : 1)
          };
        },
        onReset: lastSaved => {
          var _lastSaved$rawState$s;
          dataControlManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          selections.setValue(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.value);
          step$.next((_lastSaved$rawState$s = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.step) !== null && _lastSaved$rawState$s !== void 0 ? _lastSaved$rawState$s : 1);
        }
      });
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...dataControlManager.api,
        dataLoading$,
        getTypeDisplayName: _range_slider_strings.RangeSliderStrings.control.getDisplayName,
        serializeState,
        clearSelections: () => {
          selections.setValue(undefined);
        },
        hasSelections$: selections.hasRangeSelection$
      });
      const dataLoadingSubscription = (0, _rxjs.combineLatest)([loadingMinMax$, loadingHasNoResults$, dataControlManager.api.dataLoading$]).pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.map)(values => values.some(value => value))).subscribe(isLoading => {
        dataLoading$.next(isLoading);
      });

      // Clear state when the field changes
      const fieldChangedSubscription = (0, _rxjs.combineLatest)([dataControlManager.api.fieldName$, dataControlManager.api.dataViewId$]).pipe((0, _rxjs.skip)(1)).subscribe(() => {
        step$.next(1);
        selections.setValue(undefined);
      });
      const max$ = new _rxjs.BehaviorSubject(undefined);
      const min$ = new _rxjs.BehaviorSubject(undefined);
      const minMaxSubscription = (0, _min_max.minMax$)({
        controlFetch$,
        dataViews$: dataControlManager.api.dataViews$,
        fieldName$: dataControlManager.api.fieldName$,
        setIsLoading: isLoading => {
          // clear previous loading error on next loading start
          if (isLoading && dataControlManager.api.blockingError$.value) {
            dataControlManager.api.setBlockingError(undefined);
          }
          loadingMinMax$.next(isLoading);
        },
        controlGroupApi
      }).subscribe(({
        error,
        min,
        max
      }) => {
        if (error) {
          dataControlManager.api.setBlockingError(error);
        }
        max$.next(max !== undefined ? Math.ceil(max) : undefined);
        min$.next(min !== undefined ? Math.floor(min) : undefined);
      });
      const outputFilterSubscription = (0, _rxjs.combineLatest)([dataControlManager.api.dataViews$, dataControlManager.api.fieldName$, selections.value$]).pipe((0, _rxjs.debounceTime)(0)).subscribe(([dataViews, fieldName, value]) => {
        var _value$, _value$2;
        const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[0];
        const dataViewField = dataView && fieldName ? dataView.getFieldByName(fieldName) : undefined;
        const gte = parseFloat((_value$ = value === null || value === void 0 ? void 0 : value[0]) !== null && _value$ !== void 0 ? _value$ : '');
        const lte = parseFloat((_value$2 = value === null || value === void 0 ? void 0 : value[1]) !== null && _value$2 !== void 0 ? _value$2 : '');
        let rangeFilter;
        if (value && dataView && dataViewField && (!isNaN(gte) || !isNaN(lte))) {
          const params = {
            gte: !isNaN(gte) ? gte : -Infinity,
            lte: !isNaN(lte) ? lte : Infinity
          };
          rangeFilter = (0, _esQuery.buildRangeFilter)(dataViewField, params, dataView);
          rangeFilter.meta.key = fieldName;
          rangeFilter.meta.type = 'range';
          rangeFilter.meta.params = params;
        }
        dataControlManager.internalApi.setOutputFilter(rangeFilter);
      });
      const selectionHasNoResults$ = new _rxjs.BehaviorSubject(false);
      const hasNotResultsSubscription = (0, _has_no_results.hasNoResults$)({
        controlFetch$,
        dataViews$: dataControlManager.api.dataViews$,
        rangeFilters$: dataControlManager.api.filters$,
        ignoreParentSettings$: controlGroupApi.ignoreParentSettings$,
        setIsLoading: isLoading => {
          loadingHasNoResults$.next(isLoading);
        }
      }).subscribe(hasNoResults => {
        selectionHasNoResults$.next(hasNoResults);
      });
      if (selections.hasInitialSelections) {
        await dataControlManager.api.untilFiltersReady();
      }
      return {
        api,
        Component: ({
          className: controlPanelClassName
        }) => {
          const [dataLoading, fieldFormatter, max, min, selectionHasNoResults, step, value, fieldName] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dataLoading$, dataControlManager.api.fieldFormatter, max$, min$, selectionHasNoResults$, step$, selections.value$, dataControlManager.api.fieldName$);
          (0, _react.useEffect)(() => {
            return () => {
              dataLoadingSubscription.unsubscribe();
              fieldChangedSubscription.unsubscribe();
              hasNotResultsSubscription.unsubscribe();
              minMaxSubscription.unsubscribe();
              outputFilterSubscription.unsubscribe();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_range_slider_control.RangeSliderControl, {
            controlPanelClassName: controlPanelClassName,
            fieldName: fieldName,
            fieldFormatter: fieldFormatter,
            isInvalid: Boolean(value) && selectionHasNoResults,
            isLoading: typeof dataLoading === 'boolean' ? dataLoading : false,
            max: max,
            min: min,
            onChange: selections.setValue,
            step: step !== null && step !== void 0 ? step : 1,
            value: value,
            uuid: uuid,
            compressed: (0, _is_compressed.isCompressed)(api),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 271,
              columnNumber: 13
            }
          });
        }
      };
    }
  };
};
exports.getRangesliderControlFactory = getRangesliderControlFactory;