"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _get_cases = require("../../client/ui/get_cases");
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/app/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CasesAppComponent = ({
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  getFilesClient
}) => {
  const userCapabilities = (0, _kibana.useApplicationCapabilities)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "cases-app",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, (0, _get_cases.getCasesLazy)({
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    getFilesClient,
    owner: [_constants.APP_OWNER],
    useFetchAlertData: () => [false, {}],
    permissions: userCapabilities.generalCasesV3,
    basePath: '/',
    features: {
      alerts: {
        enabled: true,
        sync: false
      },
      observables: {
        enabled: true,
        autoExtract: false
      }
    }
  }));
};
CasesAppComponent.displayName = 'CasesApp';
const CasesApp = exports.CasesApp = /*#__PURE__*/_react.default.memo(CasesAppComponent);