"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetAgents = getFleetAgents;
var _lodash = require("lodash");
var _get_internal_saved_objects_client = require("../../lib/helpers/get_internal_saved_objects_client");
var _get_apm_package_policies = require("./get_apm_package_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFleetAgentByIds({
  policyIds,
  coreStart,
  fleetPluginStart
}) {
  // @ts-ignore
  const savedObjectsClient = await (0, _get_internal_saved_objects_client.getInternalSavedObjectsClient)(coreStart);
  return await fleetPluginStart.agentPolicyService.getByIds(savedObjectsClient, policyIds);
}
async function getFleetAgents({
  fleetPluginStart,
  cloudPluginSetup,
  coreStart
}) {
  const cloudStandaloneSetup = cloudPluginSetup ? {
    apmServerUrl: cloudPluginSetup === null || cloudPluginSetup === void 0 ? void 0 : cloudPluginSetup.apm.url,
    secretToken: cloudPluginSetup === null || cloudPluginSetup === void 0 ? void 0 : cloudPluginSetup.apm.secretToken
  } : undefined;
  if (!fleetPluginStart) {
    return {
      cloudStandaloneSetup,
      fleetAgents: [],
      isFleetEnabled: false
    };
  }

  // fetches package policies that contains APM integrations
  const packagePolicies = await (0, _get_apm_package_policies.getApmPackagePolicies)({
    coreStart,
    fleetPluginStart
  });
  const policiesGroupedById = (0, _lodash.keyBy)(packagePolicies.items, 'policy_id');

  // fetches all agents with the found package policies
  const fleetAgents = await getFleetAgentByIds({
    policyIds: Object.keys(policiesGroupedById),
    coreStart,
    fleetPluginStart
  });
  return {
    cloudStandaloneSetup,
    isFleetEnabled: true,
    fleetAgents: fleetAgents.map(agent => {
      var _packagePolicy$inputs, _packagePolicyVars$ur, _packagePolicyVars$se;
      const packagePolicy = policiesGroupedById[agent.id];
      const packagePolicyVars = (_packagePolicy$inputs = packagePolicy.inputs[0]) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.vars;
      return {
        id: agent.id,
        name: agent.name,
        apmServerUrl: packagePolicyVars === null || packagePolicyVars === void 0 ? void 0 : (_packagePolicyVars$ur = packagePolicyVars.url) === null || _packagePolicyVars$ur === void 0 ? void 0 : _packagePolicyVars$ur.value,
        secretToken: packagePolicyVars === null || packagePolicyVars === void 0 ? void 0 : (_packagePolicyVars$se = packagePolicyVars.secret_token) === null || _packagePolicyVars$se === void 0 ? void 0 : _packagePolicyVars$se.value
      };
    })
  };
}