"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLink = ServiceLink;
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../../../common/agent_name");
var _i18n2 = require("../../../../../../common/i18n");
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _style = require("../../../../../utils/style");
var _popover_tooltip = require("../../../popover_tooltip");
var _truncate_with_tooltip = require("../../../truncate_with_tooltip");
var _max_groups_message = require("../max_groups_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/service_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledLink = (0, _styled.default)(_eui.EuiLink)`
  ${(0, _style.truncate)('100%')};
`;
function formatString(value) {
  return value || _i18n2.NOT_AVAILABLE_LABEL;
}
function ServiceLink({
  agentName,
  query,
  serviceName
}) {
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const serviceLink = (0, _agent_name.isMobileAgentName)(agentName) ? '/mobile-services/{serviceName}/overview' : '/services/{serviceName}/overview';
  if (serviceName === _max_groups_message.OTHER_SERVICE_NAME) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      style: {
        fontStyle: 'italic',
        fontSize: '1rem'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.serviceLink.otherBucketName', {
      defaultMessage: 'Remaining Services'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
      ariaLabel: _i18n.i18n.translate('xpack.apm.serviceLink.tooltip', {
        defaultMessage: 'Number of services instrumented has reached the current capacity of the APM server'
      }),
      iconType: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        width: `${_style.unit * 28}px`
      },
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_max_groups_message.MaxGroupsMessage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 15
      }
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
    "data-test-subj": "apmServiceListAppLink",
    text: formatString(serviceName),
    content: /*#__PURE__*/_react.default.createElement(StyledLink, {
      "data-test-subj": `serviceLink_${agentName}`,
      href: apmRouter.link(serviceLink, {
        path: {
          serviceName
        },
        query
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
      agentName: agentName,
      size: "l",
      role: "presentation",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    }, serviceName)))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
}