"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionColdstartRateChart = TransactionColdstartRateChart;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _get_comparison_options = require("../../time_comparison/get_comparison_options");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _get_comparison_chart_theme = require("../../time_comparison/get_comparison_chart_theme");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/transaction_coldstart_rate_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function yLabelFormat(y) {
  return (0, _formatters.asPercent)(y || 0, 1);
}
const INITIAL_STATE = {
  currentPeriod: {
    transactionColdstartRate: [],
    average: null
  },
  previousPeriod: {
    transactionColdstartRate: [],
    average: null
  }
};
function TransactionColdstartRateChart({
  height,
  showAnnotations = true,
  environment,
  kuery,
  transactionName,
  comparisonEnabled,
  offset
}) {
  var _data$currentPeriod$t, _data$currentPeriod, _data$previousPeriod$, _data$previousPeriod;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName,
    transactionType,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const endpoint = transactionName ? 'GET /internal/apm/services/{serviceName}/transactions/charts/coldstart_rate_by_transaction_name' : 'GET /internal/apm/services/{serviceName}/transactions/charts/coldstart_rate';
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve(INITIAL_STATE);
    }
    if (transactionType && serviceName && start && end) {
      return callApmApi(endpoint, {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionType,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            ...(transactionName ? {
              transactionName
            } : {})
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, transactionType, transactionTypeStatus, transactionName, offset, endpoint, comparisonEnabled]);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const timeseries = [{
    data: (_data$currentPeriod$t = data === null || data === void 0 ? void 0 : (_data$currentPeriod = data.currentPeriod) === null || _data$currentPeriod === void 0 ? void 0 : _data$currentPeriod.transactionColdstartRate) !== null && _data$currentPeriod$t !== void 0 ? _data$currentPeriod$t : [],
    type: 'linemark',
    color: euiTheme.colors.vis.euiColorVis5,
    title: _i18n.i18n.translate('xpack.apm.coldstartRate.chart.coldstartRate', {
      defaultMessage: 'Cold start rate (avg.)'
    })
  }, ...(comparisonEnabled ? [{
    data: (_data$previousPeriod$ = data === null || data === void 0 ? void 0 : (_data$previousPeriod = data.previousPeriod) === null || _data$previousPeriod === void 0 ? void 0 : _data$previousPeriod.transactionColdstartRate) !== null && _data$previousPeriod$ !== void 0 ? _data$previousPeriod$ : [],
    type: 'area',
    color: euiTheme.colors.mediumShade,
    title: previousPeriodLabel
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.coldstartRate', {
    defaultMessage: 'Cold start rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.serviceOverview.coldstartHelp', {
      defaultMessage: 'The cold start rate indicates the percentage of requests that trigger a cold start of a serverless function.'
    }),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: "coldstartRate",
    height: height,
    showAnnotations: showAnnotations,
    fetchStatus: status,
    timeseries: timeseries,
    yLabelFormat: yLabelFormat,
    yDomain: {
      min: 0,
      max: 1
    },
    customTheme: comparisonChartTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }));
}