"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JavaAgentVersionInput = JavaAgentVersionInput;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_agents/runtime_attachment/java_agent_version_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function JavaAgentVersionInput({
  isValid,
  version,
  onChange
}) {
  var _services$docLinks;
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/fleet/java_agent_versions');
  }, []);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const agentJavaVersions = !isLoading && data !== null && data !== void 0 && data.versions ? data.versions.map(label => ({
    label
  })) : [];
  const hasOptions = !!agentJavaVersions.length;
  const selectedOption = [{
    label: version
  }];
  const comboProps = !hasOptions ? {
    // Leaving the onCreateOption out disables custom option
    // so only enables it when no options was returned from the API
    onCreateOption: nextVersion => {
      onChange(nextVersion);
    }
  } : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.version', {
      defaultMessage: 'Version'
    }),
    isInvalid: !isValid,
    error: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.version.invalid', {
      defaultMessage: 'Invalid version'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.version.helpText",
      defaultMessage: "Enter the {versionLink} of the Elastic APM Java agent that should be attached.",
      values: {
        versionLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmJavaAgentVersionInputVersionLink",
          href: `${(_services$docLinks = services.docLinks) === null || _services$docLinks === void 0 ? void 0 : _services$docLinks.ELASTIC_WEBSITE_URL}/guide/en/apm/agent/java/current/release-notes.html`,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.version.helpText.version', {
          defaultMessage: 'version'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: !isValid,
    placeholder: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.versionSelect.placeHolder', {
      defaultMessage: 'Select a version'
    }),
    singleSelection: {
      asPlainText: true
    },
    isLoading: isLoading,
    noSuggestions: !hasOptions,
    isClearable: !hasOptions,
    options: agentJavaVersions,
    selectedOptions: selectedOption,
    onChange: selectedOptions => {
      var _selectedOptions$;
      const nextVersion = (_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.label;
      onChange(nextVersion || '');
    }
  }, comboProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }))));
}