"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDatePickerStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1gj9wh1-euiDatePicker",
  styles: "display:block;label:euiDatePicker;"
} : {
  name: "1gj9wh1-euiDatePicker",
  styles: "display:block;label:euiDatePicker;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDatePickerStyles = exports.euiDatePickerStyles = function euiDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var inlineStyles = "\n      /* removes form layout border */\n      &::after {\n        display: none;\n      }\n    ";
  return {
    euiDatePicker: _ref,
    inline: {
      inline: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout{", (0, _global_styling.logicalCSS)('height', 'auto'), " ", (0, _global_styling.logicalCSS)('width', 'fit-content'), " border:none;padding:0;", isRefreshVariant && inlineStyles, ";}.euiFormControlLayout__childrenWrapper{flex-direction:column;}.euiFormControlLayoutIcons{justify-content:center;", (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.s), ";};label:inline;"),
      // Skip css`` to avoid generating an Emotion className
      noShadow: "\n        .euiFormControlLayout {\n          background-color: transparent;\n        }\n      ",
      shadow: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout{background-color:", euiTheme.colors.emptyShade, ";", (0, _euiThemeCommon.euiShadowMedium)(euiThemeContext, {
        borderAllInHighContrastMode: true
      }), ";};label:shadow;"),
      // Needs to come before shadow CSS so that it doesn't override their background-colors
      invalid: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout{", (0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
        withBorder: false
      }), " ", (0, _form.euiFormControlInvalidStyles)(euiThemeContext), ";};label:invalid;"),
      // Should come after shadow CSS to override their background-colors
      disabled: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout{", (0, _form.euiFormControlDisabledStyles)(euiThemeContext), ";};label:disabled;"),
      readOnly: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout{", (0, _form.euiFormControlReadOnlyStyles)(euiThemeContext), ";};label:readOnly;")
    },
    inGroup: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{.euiPopover,.react-datepicker__input-container{", (0, _global_styling.logicalCSS)('height', '100%'), ";}};label:inGroup;")
  };
};