"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _drag_drop_context_wrapper = require("../../common/components/drag_and_drop/drag_drop_context_wrapper");
var _page = require("../../common/components/page");
var _help_menu = require("../../common/components/help_menu");
var _sourcerer_paths = require("../../sourcerer/containers/sourcerer_paths");
var _global_header = require("./global_header");
var _console_manager = require("../../management/components/console/components/console_manager");
var _use_url_state = require("../../common/hooks/use_url_state");
var _use_update_browser_title = require("../../common/hooks/use_update_browser_title");
var _use_update_execution_context = require("../../common/hooks/use_update_execution_context");
var _use_upgrade_security_packages = require("../../detection_engine/rule_management/logic/use_upgrade_security_packages");
var _rule_monitoring = require("../../detection_engine/rule_monitoring");
var _top_values_popover = require("../components/top_values_popover/top_values_popover");
var _use_init_sourcerer = require("../../sourcerer/containers/use_init_sourcerer");
var _use_init_data_view_manager = require("../../data_view_manager/hooks/use_init_data_view_manager");
var _use_sync_url_state = require("../../data_view_manager/hooks/use_sync_url_state");
var _use_browser_fields = require("../../data_view_manager/hooks/use_browser_fields");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/home/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HomePageComponent = ({
  children
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    browserFields: oldBrowserFields
  } = (0, _use_init_sourcerer.useInitSourcerer)((0, _sourcerer_paths.getScopeFromPath)(pathname, false));
  const {
    browserFields: experimentalBrowserFields
  } = (0, _use_browser_fields.useBrowserFields)((0, _sourcerer_paths.getScopeFromPath)(pathname, newDataViewPickerEnabled));
  (0, _use_sync_url_state.useRestoreDataViewManagerStateFromURL)((0, _use_init_data_view_manager.useInitDataViewManager)(), (0, _sourcerer_paths.getScopeFromPath)(pathname, newDataViewPickerEnabled));
  (0, _use_url_state.useUrlState)();
  (0, _use_update_browser_title.useUpdateBrowserTitle)();
  (0, _use_update_execution_context.useUpdateExecutionContext)();
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;

  // side effect: this will attempt to upgrade the endpoint package if it is not up to date
  // this will run when a user navigates to the Security Solution app and when they navigate between
  // tabs in the app. This is useful for keeping the endpoint package as up to date as possible until
  // a background task solution can be built on the server side. Once a background task solution is available we
  // can remove this.
  (0, _use_upgrade_security_packages.useUpgradeSecurityPackages)();
  (0, _rule_monitoring.useSetupDetectionEngineHealthApi)();
  return /*#__PURE__*/_react.default.createElement(_page.SecuritySolutionAppWrapper, {
    id: "security-solution-app",
    className: "kbnAppWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_console_manager.ConsoleManager, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_global_header.GlobalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_drag_drop_context_wrapper.DragDropContextWrapper, {
    browserFields: browserFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, children), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_top_values_popover.TopValuesPopover, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))));
};
HomePageComponent.displayName = 'HomePage';
const HomePage = exports.HomePage = /*#__PURE__*/_react.default.memo(HomePageComponent);